/*
This module is guaranteed not to generate exceptions.
Methods will either succeed, assert, or return an errcode (if returning int).
*/
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <assert.h>
#include <stdarg.h>

#include "atointernal.h"
#include "atotypes.h"
#include "atostr.h"
#include "atoutil.h"
#include "atolog.h"
#include "atolst.h"

#include "atoiter.h"

static const char *_library = ATO_BASE_LIBRARY;
static const char *_module = ATO_BASE_MODULE_ITER;
static unsigned long _moduleid = ATO_BASE_MODULEID_ITER;

static int _loglevel = ATO_LOG_WARN;

/*********************************************************************************/
//Should do this as a union.
struct _ato_Iterator {
    bool islist;
    //// ato_iter_create_lst
    ato_List *list;
    ato_ListNode *node;
    //// ato_iter_create_arr
    void **arr;
    size_t index;
    size_t count;
};

/*********************************************************************************/
static void _setloglevel(ato_eLoglevel level)
{
    _loglevel = level;
}

/*********************************************************************************/
ato_Iterator *ato_iter_create_lst(ato_List *list)
{
    ato_Iterator *iter = NULL;
    if (list) {
        iter = calloc(1, sizeof(ato_Iterator));
        assert(iter != NULL);
        iter->islist = TRUE;
        iter->list = list;
        iter->node = NULL;
    }
    return iter;
}
ato_Iterator *ato_iter_create_arr(void **arr, size_t count)
{
    ato_Iterator *iter = NULL;
    if (arr) {
        iter = calloc(1, sizeof(ato_Iterator));
        assert(iter != NULL);
        iter->arr = arr;
        iter->index = 0;
        iter->count = count;
    }
    return iter;
}

void *ato_iter_firstv(ato_Iterator *iter)
{
    if (!iter) return NULL;
    if (iter->islist) {
        iter->node = ato_lst_next(iter->list, NULL);
        return ato_lst_value(iter->node);
    } else {
        iter->index = 0;
        if (iter->index >= iter->count) return NULL;
        return iter->arr[iter->index];
    }

}

void *ato_iter_nextv(ato_Iterator *iter)
{
    if (!iter) return NULL;
    if (iter->islist) {
        iter->node = ato_lst_next(iter->list, iter->node);
        return ato_lst_value(iter->node);
    } else {
        iter->index++;
        if (iter->index >= iter->count) return NULL;
        return iter->arr[iter->index];
    }
}

void ato_iter_free(ato_Iterator *iter)
{
    if (iter) free(iter);
}
/*********************************************************************************/

int ato__iter_init(void)
{
    static bool invoked = FALSE;
    if (invoked) return ATO_ERR_OK;
    invoked = TRUE;

    ato_initfnloglevel(_library, _module, _moduleid, _loglevel, _setloglevel);
    return ATO_ERR_OK;
}
void ato__iter_deinit(void)
{
}
/*********************************************************************************/
