#ifndef __ATO_BNET_LIB_H__
#define __ATO_BNET_LIB_H__

/** @addtogroup atobnet_api_lib

@{
*/

#ifdef __cplusplus
extern "C" {
#endif

/**
Return the version of the BNET library.
@return version in the form major.minor.patch.tweak (not all levels may be present)
*/
ATO_BNET_EXPORT const char *ato_bnet_version(void);


/**
Returns whether or not the library is initialised.

@return TRUE or FALSE.
*/
ATO_BNET_EXPORT bool ato_bnet_isinited(void);

/**
Initialise the SDK. This must be called at application startup prior to any threads being started.

ato_base_init() must be called first.

@param ctx the current thread local Context.
@param flag used to control the initialisation process - use ATO_BNET_INIT_ALL unless advised otherwise.

@return ATO_ERR_OK
*/
ATO_BNET_EXPORT int ato_bnet_init(ato_Ctx *ctx, unsigned short flag);
/**
Deinitialise the SDK. This must be called at application shutdown after threads are finished and
any allocated objects freed.

ato_base_deinit() should be called after all other deinitialisation routines are called.
*/
ATO_BNET_EXPORT void ato_bnet_deinit(void);


#ifdef __cplusplus
}
#endif

/*! @} */

#endif /*__ATO_BNET_LIB_H__*/
