#ifndef __ATO_BNET_TYPES_H__
#define __ATO_BNET_TYPES_H__

/** @addtogroup atobnet_api_types

*/

/** @defgroup atobnet_api_types_modules Module defines
@ingroup atobnet_api_types
Each module within the library is individually defined by a name and id.
These can be used to target logging for particular modules and to identify the source of errors.
When setting logging, the MODULEID values can be bitwised or-ed.

Note that not all modules are necessarily exposed via a public API, even though they appear here.

@{
*/
#define ATO_BNET_LIBRARY "atobnet" /**< Short text Name of the library */
#define ATO_BNET_MODULE_LIB "lib" /**< Short text Name of the primary lib module */
#define ATO_BNET_MODULE_NET "bnet" /**< Short text Name of the Network module */
#define ATO_BNET_MODULE_NETD "netd" /**< Short text Name of the Network Data module */
#define ATO_BNET_MODULE_ERRFN "errfn" /**< Short text Name of the error callback module */

#define ATO_BNET_MODULEID_LIB    0x00000001UL /**< The lib module id. */
#define ATO_BNET_MODULEID_NET    0x00000002UL /**< The Network module id. */
#define ATO_BNET_MODULEID_NETD   0x00000004UL /**< The Network Data module id. */
#define ATO_BNET_MODULEID_ERRFN  0x00000008UL /**< The error callback module id. */

/**
The ATO_BNET_INIT_... defines are used to control the initialisation that takes place. Currently
only ATO_BNET_INIT_ALL is defined.
*/
#define ATO_BNET_INIT_ALL 0xffff

/** @} */

#ifdef __cplusplus
extern "C" {
#endif


#ifdef __cplusplus
}
#endif

/** @defgroup atobnet_api_types_errcodes AKM Error codes
@ingroup atobnet_api_typess
All errors are encapsulated in AKM specific errors.
For the underlying error, use ato_err_inner() to retrieve nested errors and their details.

@{
*/

#define ATO_BNET_ERR_MIN 11500 /**< The mimimum error number. */
#define ATO_BNET_ERR_GENERAL (ATO_BNET_ERR_MIN+1)  /**< For errors not otherwise specified. */

#define ATO_BNET_ERR_NETSENDER (ATO_BNET_ERR_MIN+2) /**< A SOAP fault generated by the sender, not including service unavailable. */
#define ATO_BNET_ERR_NETRECEIVER (ATO_BNET_ERR_MIN+3) /**< A SOAP fault generated by the receiver, not including service unavailable. */
#define ATO_BNET_ERR_NETUNAVAILABLE (ATO_BNET_ERR_MIN+4) /**< A SOAP fault where the remote service is unavailable. */
#define ATO_BNET_ERR_NETCOMMS (ATO_BNET_ERR_MIN+5) /**< A general network error has occurred, not including timeouts. */
#define ATO_BNET_ERR_NETTIMEOUT (ATO_BNET_ERR_MIN+6)  /**< A network time has occured trying to connect to a remote service. */

#define ATO_BNET_ERR_MAX (ATO_BNET_ERR_MIN+200) /**< The maximum error number. */
/** @} */

#endif /*__ATO_BNET_TYPES_H__*/
