#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <time.h>
#include <stdarg.h>

#include "akversion.h"

#include "atobase/private/pall.h"

#include "atointernal.h"
#include "atotypes.h"
#include "atonetd.h"
#include "atobnet.h"
#include "atoerrfn.h"
#include "atolib.h"

static const char *_library = ATO_BNET_LIBRARY;
static const char *_module = ATO_BNET_MODULE_LIB;
static unsigned long _moduleid = ATO_BNET_MODULEID_LIB;

static int _loglevel = ATO_LOG_WARN;

static bool _ato_inited = FALSE;

/*********************************************************************************/
//static int _init(void);
static void _load_errdefs(void);

/*********************************************************************************/
const char *ato_bnet_version(void) { return ATOBNET_VERSION; }

static void _setloglevel(ato_eLoglevel level)
{
        _loglevel = level;
}

int ato__bnetlib_init(void)
{
        static bool invoked = FALSE;
        if (invoked) return ATO_ERR_OK;
        invoked = TRUE;

        ato_initfnloglevel(_library, _module, _moduleid, _loglevel, _setloglevel);
        return ATO_ERR_OK;
}
void ato__bnetlib_deinit(void)
{
        static bool invoked = FALSE;
        if (invoked) return;
        invoked = TRUE;
}

int ato__bnetlib_process_errcode(ato_Ctx *ctx, int errcode, const char *module, const char *function, int line)
{
        int liberrcode = ATO_BNET_ERR_GENERAL;
        if (errcode == ATO_ERR_OK)
                return errcode;
        if (errcode >= ATO_BNET_ERR_MIN && errcode <= ATO_BNET_ERR_MAX)
                return errcode;

        if (errcode == ATO_ERR_NET_TIMEOUT)
                liberrcode = ATO_BNET_ERR_NETTIMEOUT;
        else if (errcode == ATO_ERR_NET_SOAP)
                liberrcode = ATO_BNET_ERR_NETRECEIVER;
        else if (errcode == ATO_ERR_NET)
                liberrcode = ATO_BNET_ERR_NETCOMMS;
        return ato_ctx_err_new(ctx, _library, module, function, line, liberrcode, ATO_ESEVERITY_WARN, NULL, "");
}

/*********************************************************************************/
bool ato_bnet_isinited(void)
{
        return _ato_inited;
}

int ato_bnet_init(ato_Ctx *ctx, unsigned short flag) {
        const char *function = "ato_bnet_init";
        static bool invoked = FALSE;
        int errcode = ATO_ERR_OK;
        if (invoked) return ATO_ERR_OK;
        invoked = TRUE;

        assert(ato_base_isinited() == TRUE);
        assert(flag != 0); ATO_IGNORE(flag);
        assert(ctx != NULL);
        _load_errdefs();

        //errcode = _init();

        if (errcode == ATO_ERR_OK)
                errcode = ato__bnetlib_init();

        if (errcode == ATO_ERR_OK)
                errcode = ato__netd_init();
        if (errcode == ATO_ERR_OK)
                errcode = ato__net_init();

        //ato_errh_sethandler(ato__akm_errfn, ATO_BNET_LIBRARY);

        if (errcode != ATO_ERR_OK)
                ATO_CTX_NEWERR(ctx, errcode, "Failed to initialise BNET library");
    _ato_inited = (errcode == ATO_ERR_OK);
        return errcode;
}


void ato_bnet_deinit(void)
{
        static bool invoked = FALSE;
        if (invoked) return;
        invoked = TRUE;

        ato__net_deinit();
        ato__netd_deinit();
        ato__bnetlib_deinit();
}

/*********************************************************************************/
#define _ATO_ADD_ERRDEF(code, name, msg) ato_errdef_add(code, _library, name, msg)
static void _load_errdefs(void)
{
        _ATO_ADD_ERRDEF(ATO_BNET_ERR_GENERAL, "ATO_BNET_ERR_GENERAL", "For errors not otherwise specified");
        _ATO_ADD_ERRDEF(ATO_BNET_ERR_NETSENDER, "ATO_BNET_ERR_NETSENDER", "A SOAP fault generated by the sender, not including service unavailable");
        _ATO_ADD_ERRDEF(ATO_BNET_ERR_NETRECEIVER, "ATO_BNET_ERR_NETRECEIVER", "A SOAP fault generated by the receiver, not including service unavailable");
        _ATO_ADD_ERRDEF(ATO_BNET_ERR_NETUNAVAILABLE, "ATO_BNET_ERR_NETUNAVAILABLE", "A SOAP fault where the remote service is unavailable");
        _ATO_ADD_ERRDEF(ATO_BNET_ERR_NETCOMMS, "ATO_BNET_ERR_NETCOMMS", "A general network error has occurred, not including timeouts");
        _ATO_ADD_ERRDEF(ATO_BNET_ERR_NETTIMEOUT, "ATO_BNET_ERR_CRYPTO", "A network time has occured trying to connect to a remote service");
}
/*********************************************************************************/


/*********************************************************************************/

