#ifndef __ATO_STM_LIB_H__
#define __ATO_STM_LIB_H__

/** @addtogroup atostm_api_lib

@{
*/

#ifdef __cplusplus
extern "C" {
#endif

/**
Return the version of the ATO Security Token Manager API.
@return version in the form major.minor.patch.tweak (not all levels may be present)
*/
ATO_STM_EXPORT const char *ato_stm_version(void);

/**
Initialise the SDK.

This must be called at application startup prior to any threads being started.

ato_base_init() must be called first.

@param ctx the current thread local Context.
@param flag used to control the initialisation process - use ATO_STM_INIT_ALL unless advised otherwise.

@return ATO_ERR_OK or an errcode.
*/
ATO_STM_EXPORT int ato_stm_init(ato_Ctx *ctx, unsigned short flag);
/**
Deinitialise the SDK. This must be called at application shutdown after threads are finished and
any allocated objects freed.

ato_base_deinit() should be called after all other deinitialisation routines are called.
*/
ATO_STM_EXPORT void ato_stm_deinit(void);

/**
The default filename for the STM template file.

@return the default STM template filename.
*/
ATO_STM_EXPORT const char *ato_stm_default_templatefile(void);

/**
Helper method to load an STM template from a path.

@param ctx the current thread local Context.
@param buffer the address of the buffer to load the contents into - must be freed by the caller.
@param dirname the directory to use. Cannot be NULL. Can include or be the filename.
@param filename the filename to use. Can be NULL if just using dirname.

@return ATO_ERR_OK or an errcode.
*/
ATO_STM_EXPORT int ato_stm_loadtemplate(ato_Ctx *ctx, char **buffer, const char *dirname, const char *filename);

#ifdef __cplusplus
}
#endif

/*! @} */

#endif /*__ATO_STM_LIB_H__*/
