#ifndef __ATO_STM_TYPES_H__
#define __ATO_STM_TYPES_H__

/** @addtogroup atostm_api_types

*/

/** @defgroup atostm_api_types_modules Module defines
@ingroup atostm_api_types
Each module within the library is individually defined by a name and id.
These can be used to target logging for particular modules and to identify the source of errors.
When setting logging, the MODULEID values can be bitwised or-ed.

Note that not all modules are necessarily exposed via a public API, even though they appear here.

@{
*/
#define ATO_STM_LIBRARY       "atostm" /**< The name of the library. */
#define ATO_STM_MODULE_LIB    "lib" /**< The lib module name. */
#define ATO_STM_MODULE_STM    "stm" /**< The stm module name. */
#define ATO_STM_MODULE_TKN    "tkn" /**< The tkn module name.*/
#define ATO_STM_MODULE_ERRFN  "errfn" /**< The errfn module name.*/

#define ATO_STM_MODULEID_LIB    0x00000001UL /**< The lib module id. */
#define ATO_STM_MODULEID_STM    0x00000002UL /**< The stm module id. */
#define ATO_STM_MODULEID_TKN    0x00000004UL /**< The tkn module id. */
#define ATO_STM_MODULEID_ERRFN  0x00000008UL /**< The errfn module id. */

/**
The ATO_STM_INIT_... defines are used to control the initialisation that takes place. Currently
only ATO_STM_INIT_ALL is defined.
*/
#define ATO_STM_INIT_ALL 0xffff

/** @} */

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
}
#endif

/** @defgroup atostm_api_types_errcodes Error codes
@ingroup atostm_api_types
All errors are encapsulated in STM specific errors.
For the underlying error, use ato_err_inner() to retrieve nested errors and their details.


@{
*/

#define ATO_STM_ERR_MIN 13000 /**< The mimimum error number. */
#define ATO_STM_ERR_GENERAL (ATO_STM_ERR_MIN+1)  /**< For errors not specified below. */
#define ATO_STM_ERR_NETSENDER (ATO_STM_ERR_MIN+2) /**< A SOAP fault generated by the sender, not including service unavailable. */
#define ATO_STM_ERR_NETRECEIVER (ATO_STM_ERR_MIN+3) /**< A SOAP fault generated by the receiver, not including service unavailable. */
#define ATO_STM_ERR_NETUNAVAILABLE (ATO_STM_ERR_MIN+4) /**< A SOAP fault where the remote service is unavailable. */
#define ATO_STM_ERR_NETCOMMS (ATO_STM_ERR_MIN+5) /**< A general network error has occurred, not including timeouts. */
#define ATO_STM_ERR_NETTIMEOUT (ATO_STM_ERR_MIN+6)  /**< A network time has occured trying to connect to a remote service. */
#define ATO_STM_ERR_MAX (ATO_STM_ERR_MIN+200) /**< The maximum error number. */
/** @} */

#endif /*__ATO_STM_TYPES_H__*/
