#ifndef __ATO_STM_STM_INTERNAL_H__
#define __ATO_STM_STM_INTERNAL_H__

#ifndef ATO_STM_INTERNAL
#error "This file is for internal use only"
#endif

#include "atostm/stm.h"

#ifdef __cplusplus
extern "C" {
#endif

extern int ato__stm_init(void);
extern void ato__stm_deinit(void);

extern void ato__stm_create(ato_Ctx *ctx, ato_Stm **obj, const char *stsurl, const char *stmtemplate);
extern bool ato__stm_setexpirytime(ato_Ctx *ctx, ato_Stm *stm, size_t expirymins);
extern void ato__stm_stsissue(ato_Ctx *ctx, ato_Stm *stm, ato_StmTkn **st, ato_String *certificate, ato_String *privatekey, const char *relyingpartyurl);
extern void ato__stm_loadst(ato_Ctx *ctx, ato_Stm *stm, ato_StmTkn **st, ato_String *atorstr);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_STM_STM_INTERNAL_H__*/
