/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atostm_gettingstarted_error

ATOSTM uses the error handling mechanism in ATOBASE.

For iterating errors see @ref atobase_error_iterating.

ATOSTM API methods which return errcodes will always return an ATO_STM_ERR_.. code. For details on
errcodes see @ref atostm_api_types_errcodes.

Top level errcodes can be checked using:

@code
    switch (errcode) {
        case ATO_STM_ERR_GENERAL:
            printf("STM General error: ");
            break;
        case ATO_STM_ERR_NETSENDER:
            printf("STM Sender error: ");
            break;
        case ATO_STM_ERR_NETRECEIVER:
            printf("STM Receiver error: ");
            break;
        case ATO_STM_ERR_NETUNAVAILABLE:
            printf("STM Remote Service not available: ");
            break;
        case ATO_STM_ERR_NETCOMMS:
            printf("STM Network error: ");
            break;
        case ATO_STM_ERR_NETTIMEOUT:
            printf("STM Remote Service timeout: ");
            break;
    }
@endcode

*/
