/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atostm_designnotes

@section atostm_designnotes_content Content

The organisation is similar to @ref atobase_designnotes_content "the ATO Base SDK documentation".

@section atostm_designnotes_usage Usage

Using the SDK follows the pattern:

- Create an application context (there has to be one per thread including the main application thread)
- Initialise the system at application startup
    - Load a Configuration Manager and configuration and attach to the thread context
    - ATO AKM (if retrieving cryptographic material from ATOMAS OR source from somewhere else)
        - Create one or more keystore objects (passing through the context object if any)
            - Perform keystore operations
            - Retrieve one or more credentials from the keystore
                - Perform credential operations
        - Free any keystore objects created
    - ATO STM
        - Load the template, specifying the final endpoint, and certificate
        - Request a Security Token using the private key
        - If successful, retrieve returned values
            - the Proof Token
            - the Encrypted Assertion
        - Free any STM objects created
- Free the thread context; free the Configuration Manager
- Deinitialise the system at application shutdown

Note: initialisation / deinitialises must be perform before / after any threading.

*/
