#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <time.h>
#include <stdarg.h>

#include "libxml/tree.h"
#include "libxml/parser.h"
#include "libxml/xpath.h"
#include "libxml/xpathInternals.h"
#include "libxml/xmlmemory.h"

#include "xmlsec/xmlsec.h"
#include "xmlsec/xmltree.h"
#include "xmlsec/xmldsig.h"
#include "xmlsec/crypto.h"
#include "xmlsec/parser.h"

#include "akversion.h"

#include "atobase/private/pall.h"
#include "atobnet/private/pall.h"

#include "atointernal.h"
#include "atotypes.h"
#include "atostmtkn.h"
#include "atostm.h"
#include "atoerrfn.h"
#include "atolib.h"

static const char *_library = ATO_STM_LIBRARY;
static const char *_module = ATO_STM_MODULE_LIB;
static unsigned long _moduleid = ATO_STM_MODULEID_LIB;

static int _loglevel = ATO_LOG_WARN;

static const char _defstmtemplatefile[] = "atostm_template.xml";

/*********************************************************************************/
static void _load_errdefs(void);

/*********************************************************************************/

const char *ato_stm_version(void) { return ATOSTM_VERSION; }

static void _setloglevel(ato_eLoglevel level)
{
    _loglevel = level;
}

int ato__stmlib_init(void)
{
    static bool invoked = FALSE;
    if (invoked) return ATO_ERR_OK;
    invoked = TRUE;

    ato_initfnloglevel(_library, _module, _moduleid, _loglevel, _setloglevel);
    return ATO_ERR_OK;
}
void ato__stmlib_deinit(void)
{
    static bool invoked = FALSE;
    if (invoked) return;
    invoked = TRUE;
}

int ato__stmlib_process_errcode(ato_Ctx *ctx, int errcode, const char *module, const char *function, int line)
{
    int liberrcode = ATO_STM_ERR_GENERAL;
    if (errcode == ATO_ERR_OK)
        return errcode;
    if (errcode >= ATO_STM_ERR_MIN && errcode <= ATO_STM_ERR_MAX)
        return errcode;

    if (errcode == ATO_ERR_NET_TIMEOUT)
        liberrcode = ATO_STM_ERR_NETTIMEOUT;
    else if (errcode == ATO_ERR_NET_SOAP)
        liberrcode = ATO_STM_ERR_NETRECEIVER;
    else if (errcode == ATO_ERR_NET)
        liberrcode = ATO_STM_ERR_NETCOMMS;
    return ato_ctx_err_new(ctx, _library, module, function, line, liberrcode, ATO_ESEVERITY_WARN, NULL, "");
}

/*********************************************************************************/
#define LIBXMLINITED "94C96C36-70EC-48e1-A652-475067FFEB77"
static int _ato_tmpl_init(void)
{
    static bool invoked = FALSE;
    int errcode = ATO_ERR_OK;
    if (invoked) return ATO_ERR_OK;
    invoked = TRUE;

    if (!ato_base_var(LIBXMLINITED, NULL)) {
        //printf("STM initialising xmlsec\n");
        ato_base_var_set(LIBXMLINITED, "TRUE");

        xmlLoadExtDtdDefaultValue = XML_DETECT_IDS | XML_COMPLETE_ATTRS;
        xmlSubstituteEntitiesDefault(1);

        if(xmlSecInit() < 0)  // this is emitting "error : Unknown IO error"
            errcode = 100;
        if(xmlSecCheckVersion() != 1)
            errcode = ATO_ERR_VERSION_DEP;
        if(xmlSecCryptoAppInit(NULL) < 0)
            errcode = 101;
        if(xmlSecCryptoInit() < 0)
            errcode = ATO_ERR_INIT;
    }

    return errcode;
}

static void _ato_tmpl_deinit(void) {
    const char *value = NULL;
    static bool invoked = FALSE;
    if (invoked) return;
    invoked = TRUE;

    if (ato_base_var(LIBXMLINITED, &value)) {
        if (value) {
            //printf("STM deinitialising xmlsec\n");
            ato_base_var_set(LIBXMLINITED, NULL);
            xmlSecCryptoShutdown();
            xmlSecCryptoAppShutdown();
            xmlSecShutdown();
        }
    }
}

int ato_stm_init(ato_Ctx *ctx, unsigned short flag) {
    const char *function = "ato_stm_init";
    static bool invoked = FALSE;
    int errcode = ATO_ERR_OK;
    if (invoked) return ATO_ERR_OK;
    invoked = TRUE;

    assert(flag != 0); ATO_IGNORE(flag);
        assert(ctx != NULL);

    assert(ato_base_isinited() == TRUE);
    assert(ato_bnet_isinited() == TRUE);

    _load_errdefs();

    if (errcode == ATO_ERR_OK)
        errcode = ato__stmlib_init();

    if (errcode == ATO_ERR_OK)
        errcode = _ato_tmpl_init();
    if (errcode == ATO_ERR_OK)
        errcode = ato__stm_init();
    if (errcode == ATO_ERR_OK)
        errcode = ato__stmtkn_init();

    //ato_errh_sethandler(ato__stm_errfn, ATO_STM_LIBRARY);

    if (errcode != ATO_ERR_OK)
        ATO_CTX_NEWERR(ctx, errcode, "Failed to initialise STM library");
    return errcode;
}
void ato_stm_deinit(void) {
    static bool invoked = FALSE;
    if (invoked) return;
    invoked = TRUE;

    ato__stmtkn_deinit();
    ato__stm_deinit();
    _ato_tmpl_deinit();
    ato__stmlib_deinit();
}

/*********************************************************************************/
#define _ATO_ADD_ERRDEF(code, name, msg) ato_errdef_add(code, _library, name, msg)
static void _load_errdefs(void) {
    _ATO_ADD_ERRDEF(ATO_STM_ERR_GENERAL, "ATO_STM_ERR_GENERAL", "");
    _ATO_ADD_ERRDEF(ATO_STM_ERR_NETSENDER, "ATO_STM_ERR_NETSENDER", "");
    _ATO_ADD_ERRDEF(ATO_STM_ERR_NETRECEIVER, "ATO_STM_ERR_NETRECEIVER", "");
    _ATO_ADD_ERRDEF(ATO_STM_ERR_NETUNAVAILABLE, "ATO_STM_ERR_NETUNAVAILABLE", "");
    _ATO_ADD_ERRDEF(ATO_STM_ERR_NETCOMMS, "ATO_STM_ERR_NETCOMMS", "");
    _ATO_ADD_ERRDEF(ATO_STM_ERR_NETTIMEOUT, "ATO_STM_ERR_NETTIMEOUT", "");
}
/*********************************************************************************/

const char *ato_stm_default_templatefile(void) {
    return _defstmtemplatefile;
}


int ato_stm_loadtemplate(ato_Ctx *ctx, char **buffer, const char *dirname, const char *filename) {
    const char *function = "ato_stm_loadtemplate";
    int errcode = ATO_ERR_OK;
    char *buf = NULL;
    ato_String *str = NULL;
    char *path = NULL;
    ATO_ASSERT_ISNOTALLOCATED(buffer);

    assert(dirname);
    if (filename == NULL) { filename = ""; }
    path = ato_pathcat(dirname, filename);

    errcode = ato_fileload(&str, path);
    if (errcode != ATO_ERR_OK) {
        ATO_CTX_VNEWERR(ctx, errcode, strlen(path), "Failed to load stm template file '%s'", path);
    } else {
        buf = ato_str_valueasowner(str);
    }

    if (path) free(path);
    ato_str_free(str);
    *buffer = buf;
    return errcode;
}
