set(AK_VERBOSE 0)
include("${CMAKE_CURRENT_LIST_DIR}/cmlists-init.cmake")

set(CMAKE_MODULE_PATH ${AK_CMAKE_MODULES} ${CMAKE_MODULE_PATH})
include("${CMAKE_CURRENT_LIST_DIR}/AKMaster.cmake")
include("${CMAKE_CURRENT_LIST_DIR}/AKModulesFind.cmake")
ak_ensure_out_of_source_build()

if ("${AK_PLATFORM}" STREQUAL "")
    AK_HALT("AK_PLATFORM not defined. Use cmake -C ../xxxxx.cmake <sourcedir>")
endif()

string(TOUPPER ${PROJECT_NAME} PROJECT_NAME_UPPER)
set(PROJECT_BRIEF "ATOMAS ${PROJECT_NAME}")
set(PROJECT_COPYRIGHT "2020 Commonwealth of Australia, <DPO@ato.gov.au>.")
NOW(PROJECT_TIMESTAMP)
set(PROJECT_SRC "${AK_SRC}")
set(PROJECT_HASH "${AK_HASH}")

message(STATUS)
message(STATUS "*****************************************************************************")
message(STATUS "*****************************************************************************")
message(STATUS "******* ${CMAKE_HOST_SYSTEM_NAME}-${CMAKE_SYSTEM_NAME}_${CMAKE_SYSTEM_VERSION}-${CMAKE_SYSTEM_PROCESSOR} *******")
message(STATUS "AK_PLATFORM=${AK_PLATFORM}")
message(STATUS "CMAKE_SYSTEM_PREFIX_PATH=${CMAKE_SYSTEM_PREFIX_PATH}")
message(STATUS "CMAKE_PREFIX_PATH=${CMAKE_PREFIX_PATH}")
message(STATUS "CMAKE_BUILD_TYPE=${CMAKE_BUILD_TYPE}")
message(STATUS "CMAKE_MODULE_PATH=${CMAKE_MODULE_PATH}")
message(STATUS "AK_CMAKELISTSDIR=${AK_CMAKELISTSDIR}")
message(STATUS "CMAKE_GENERATOR=${CMAKE_GENERATOR}")
message(STATUS "CMAKE_PREFIX_PATH=${CMAKE_PREFIX_PATH}")
message(STATUS "AK_BUILD_DOC=${AK_BUILD_DOC}")
message(STATUS "BUILD_SHARED_LIBS=${BUILD_SHARED_LIBS}")
message(STATUS "CMAKE_WINDOWS_EXPORT_ALL_SYMBOLS=${CMAKE_WINDOWS_EXPORT_ALL_SYMBOLS}")
message(STATUS "AK_DIR_DEP=${AK_DIR_DEP}")
message(STATUS "AK_DEP_RUNTM=${AK_DEP_RUNTM}")
message(STATUS "******* *******")
message(STATUS)
message(STATUS "******* *******")
message(STATUS "PROJECT_NAME=${PROJECT_NAME} (${PROJECT_NAME_UPPER})")
message(STATUS "PROJECT_BRIEF=${PROJECT_BRIEF}")
message(STATUS "PROJECT_COPYRIGHT=${PROJECT_COPYRIGHT}")
message(STATUS "PROJECT_TIMESTAMP=${PROJECT_TIMESTAMP}")
message(STATUS "PROJECT_SRC=${PROJECT_SRC}")
message(STATUS "PROJECT_HASH=${PROJECT_HASH}")
message(STATUS "******* *******")
message(STATUS)
#AK_HALT("xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx")


#####################################################################
if ("${AK_PLATFORM}" STREQUAL "nix")
    #set(CMAKE_FIND_LIBRARY_SUFFIXES ".a;.so") # uncomment to build against static libs if present
elseif ("${AK_PLATFORM}" STREQUAL "mac")
    set(CMAKE_FIND_LIBRARY_SUFFIXES ".a;.dylib;.tbd")
elseif ("${AK_PLATFORM}" STREQUAL "bsd")
elseif ("${AK_PLATFORM}" STREQUAL "mingw64" OR "${AK_PLATFORM}" STREQUAL "mingw32")
    set(CMAKE_FIND_LIBRARY_SUFFIXES ".a;.dll")
elseif ("${AK_PLATFORM}" STREQUAL "win")
elseif ("${AK_PLATFORM}" STREQUAL "uwp")
else()
    AK_HALT("Platform '${AK_PLATFORM}' not defined or not supported")
endif()

set(AK_VAR_STATIC_POSTFIX "a")

#####################################################################
if (AK_IS_WINDOZE)
    add_definitions(-D_CRT_SECURE_NO_WARNINGS -W4 -MD -WX)
    # There's a bug somewhere in the code that causes SBRCSR to generate corrupt data if assert is removed - we should leave it in anyway
    STRING (REGEX REPLACE "/DNDEBUG" "" CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE}")
    STRING (REGEX REPLACE "/D NDEBUG" "" CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE}")

    configure_file("${PROJECT_SOURCE_DIR}/version.in.rc" "${PROJECT_SOURCE_DIR}/src/akversion.rc" @ONLY)
else()
    # https://security.stackexchange.com/questions/24444/what-is-the-most-hardened-set-of-options-for-gcc-compiling-c-c

    # There's a bug somewhere in the code that causes SBRCSR to generate corrupt data if assert is removed - we should leave it in anyway
    STRING (REGEX REPLACE "-DNDEBUG" "" CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE}")
    # Sorry -O3 flag not supported
    STRING (REGEX REPLACE "-O3" "-O2" CMAKE_C_FLAGS_RELEASE "${CMAKE_C_FLAGS_RELEASE}")
    set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -g3")
    if ("${AK_HOST_OS}" STREQUAL "win")
        add_definitions(-Wl,dynamicbase -Wl,nxcompat)
    else()
        set(CMAKE_C_FLAGS_DEBUG "${CMAKE_C_FLAGS_DEBUG} -fsanitize=address") # DO NOT USE WITH VALGRIND
        #add_definitions(-arch x86_64)
        add_definitions(-fstack-protector-all -ftrapv)
    endif()
    add_definitions(-ansi -std=c99 -pedantic-errors -Werror -Wmissing-prototypes -Wstrict-prototypes -Wall -Wextra -Wshadow -Wcast-qual -Wwrite-strings -Wformat=2 -Wstrict-overflow=5)
    add_definitions(-Waggregate-return -Wbad-function-cast -Wcast-align -Wmissing-declarations -Wnested-externs -Wredundant-decls -Winline -Wno-error=long-long)

    if ("${AK_PLATFORM}" STREQUAL "mingw64" OR "${AK_PLATFORM}" STREQUAL "mingw32")
        set (CMAKE_POSITION_INDEPENDENT_CODE FALSE)
    else()
        add_definitions(-D_POSIX_SOURCE)
    endif()

    if ("${AK_PLATFORM}" STREQUAL "mac")
        # scary - really need to get off C - MS/Mac are wrecking it
        add_definitions(-Wno-nullability-completeness -Wno-nullability-extension -Wno-expansion-to-defined)
    endif()

    # Currently required but to be reviewed
    add_definitions(-Wno-format-nonliteral)

    #add_definitions(-Wconversion -Wsign-conversion) # this causes problems on older versions of gcc - to be reviewed at a later date
    #add_definitions(-pie -fPIE)
    if ("${CMAKE_BUILD_TYPE}" STREQUAL "Release")
        if (NOT "${AK_PLATFORM}" STREQUAL "mac") # one or more of these will cause a crash on some older versions of MacOS
            add_definitions(-D_FORTIFY_SOURCE=0 -Wstack-protector --param ssp-buffer-size=4) # -Wformat-security)
        endif()
    endif()
    #add_definitions(-mfunction-return=thunk -fstack-clash-protection -fvtable-verify=std -Wl,-z,noexecstack) # not on MacOS
    #add_definitions(-Wl,-z,relro,-z,now)
    #add_definitions(-mindirect-branch=thunk -fcf-protection=full)

    if("${AK_PLATFORM}" STREQUAL "mingw64" OR "${AK_PLATFORM}" STREQUAL "mingw32")
        add_definitions(-DWIN32 -D_WIN32 -DMINGW -D_MINGW -Wno-pedantic-ms-format)
        set (CMAKE_SHARED_LINKER_FLAGS "-Wl,--export-all-symbols")
    else()
        add_definitions(-D_ISO_C_VISIBLE=1999 -D_POSIX_C_SOURCE=200112)
        #set (CMAKE_SHARED_LINKER_FLAGS "-Wl,-z,now -Wl,-z,relro")
    endif()
    if("${AK_PLATFORM}" STREQUAL "mingw64")
        add_definitions(-Wno-format) # conflicts with format-security
    endif()

    # On some platforms (e.g. "Ubuntu 12.04 64bit Precise" has been reported), compile errors may be solved by using
    # the following flags (NOT advised, as such warning usually indicate code errors which can result in crashes).
    #add_definitions(-Wno-error=format -Wno-error=unused-but-set-variable -Wno-error=unused-value)
endif()
#####################################################################

add_definitions(-DATO_EXPORT= -DATO_AKM_EXPORT= -DATO_AKMBE_EXPORT= -DATO_STMBE_EXPORT= -DATO_BNET_EXPORT= -DATO_STM_EXPORT= -DSBR_CSR_EXPORT=)

add_definitions(-DXMLSEC_NO_XSLT -DXMLSEC_NO_CRYPTO_DYNAMIC_LOADING -DXMLSEC_CRYPTO_OPENSSL)

if (NOT ${BUILD_SHARED_LIBS})
#    add_definitions(-DATO_STATIC -DATO_AKM_STATIC -DATO_BNET_STATIC -DATO_STM_STATIC -DSBR_CSR_STATIC)
#    add_definitions(-DATO_AKMBE_STATIC -DATO_STMBE_STATIC)
    add_definitions(-DLIBXSLT_STATIC -DLIBXML_STATIC -DXMLSEC_STATIC -DCURL_STATICLIB -DNGHTTP2_STATICLIB)
endif()

configure_file("${PROJECT_SOURCE_DIR}/version.in.h" "${PROJECT_SOURCE_DIR}/src/akversion.h" @ONLY)
include_directories("${PROJECT_SOURCE_DIR}/include")
aux_source_directory("${PROJECT_SOURCE_DIR}/src" my_SOURCES)
if (EXISTS "${PROJECT_SOURCE_DIR}/common")
    aux_source_directory("${PROJECT_SOURCE_DIR}/common" common_SOURCES)
    set(my_SOURCES ${my_SOURCES} ${common_SOURCES})
endif()
if (EXISTS "${PROJECT_SOURCE_DIR}/resources")
    file(COPY "${PROJECT_SOURCE_DIR}/resources/" DESTINATION "${PROJECT_BINARY_DIR}")
endif()

#AK_HALT("my_SOURCES=${my_SOURCES}")

#####################################################################
#####################################################################
#set(CMAKE_BUILD_WITH_INSTALL_RPATH 1)
if ("${PROJECT_NAME}" MATCHES "^.*x$")
    add_executable(${PROJECT_NAME} ${my_SOURCES})

    #if("${AK_PLATFORM}" STREQUAL "mac")
    #   set_target_properties(${PROJECT_NAME} PROPERTIES INSTALL_RPATH "@loader_path")
    #endif()
else()
    add_library(${PROJECT_NAME}_obj OBJECT ${my_SOURCES})
    set_target_properties(${PROJECT_NAME}_obj PROPERTIES POSITION_INDEPENDENT_CODE 1)
    if (AK_IS_WINDOZE)
        add_library(${PROJECT_NAME} SHARED $<TARGET_OBJECTS:${PROJECT_NAME}_obj> "${PROJECT_SOURCE_DIR}/src/export_${PROJECT_NAME}.def")
    else()
        add_library(${PROJECT_NAME} SHARED $<TARGET_OBJECTS:${PROJECT_NAME}_obj>)
    endif()
    add_library(${PROJECT_NAME}.${AK_VAR_STATIC_POSTFIX} STATIC $<TARGET_OBJECTS:${PROJECT_NAME}_obj>)
    set_target_properties(${PROJECT_NAME} PROPERTIES CLEAN_DIRECT_OUTPUT 1)
    set_target_properties(${PROJECT_NAME}.${AK_VAR_STATIC_POSTFIX} PROPERTIES CLEAN_DIRECT_OUTPUT 1)
    if(NOT AK_IS_WINDOZE)
        set_target_properties(${PROJECT_NAME}.${AK_VAR_STATIC_POSTFIX} PROPERTIES OUTPUT_NAME "${PROJECT_NAME}")
    endif()
    #set_target_properties(${PROJECT_NAME} PROPERTIES OUTPUT_NAME "lib${PROJECT_NAME}")
endif()
if (AK_IS_WINDOZE)
    set(ATODEPENDENCIES_ROOT_DIR "${AK_DIR_DEP}/rt/${AK_PLATFORM}")
    include(FindAtoDependencies REQUIRED)
    message(STATUS "ATODEPENDENCIES_FOUND = ${ATODEPENDENCIES_FOUND} (${ATODEPENDENCIES_VERSION}) (${ATODEPENDENCIES_INCLUDE_DIR}) (${ATODEPENDENCIES_LIBRARY_DIR})")
    set(CMAKE_INCLUDE_PATH ${ATODEPENDENCIES_INCLUDE_DIR} ${CMAKE_INCLUDE_PATH})
    set(CMAKE_LIBRARY_PATH ${ATODEPENDENCIES_LIBRARY_DIR} ${CMAKE_LIBRARY_PATH})
    message(STATUS "CMAKE_INCLUDE_PATH=${CMAKE_INCLUDE_PATH}")
    message(STATUS "CMAKE_LIBRARY_PATH=${CMAKE_LIBRARY_PATH}")
elseif("${AK_PLATFORM}" STREQUAL "mingw64" OR "${AK_PLATFORM}" STREQUAL "mingw32")
    # MSYS2 bug? This avoids the need to rebuild the libxml2 package. https://github.com/Alexpux/MINGW-packages/issues/2125
    set_target_properties(${PROJECT_NAME} PROPERTIES LINK_FLAGS "-Wl,--allow-multiple-definition")
endif()

set_target_properties(${PROJECT_NAME} PROPERTIES
    SOVERSION ${${PROJECT_NAME}_VERSION_MAJOR}
    VERSION ${${PROJECT_NAME}_VERSION_MAJOR}.${${PROJECT_NAME}_VERSION_MINOR}.${${PROJECT_NAME}_VERSION_PATCH}
)

set(AK_DEP_LIBS "")

include("${AK_CMAKE_MODULES}/cmlists-doc.cmake")
