#ifndef __SBR_CSR_LIB_H__
#define __SBR_CSR_LIB_H__

/** @addtogroup sbrcsr_api_csr_lib

@{
*/

#ifdef __cplusplus
extern "C" {
#endif

/**
Return the version of the SBR Core Services Requester API.
@return version in the form major.minor.patch.tweak (not all levels may be present)
*/
SBR_CSR_EXPORT const char *sbr_csr_version(void);

/**
Initialise the SDK.

This must be called at application startup prior to any threads being started.

ato_base_init() must be called first.

@param ctx the current thread local Context.
@param flag used to control the initialisation process - use SBR_CSR_INIT_ALL unless advised otherwise.

@return ATO_ERR_OK or an errcode.
*/
SBR_CSR_EXPORT int sbr_csr_init(ato_Ctx *ctx, unsigned short flag);
/**
Deinitialise the SDK. This must be called at application shutdown after threads are finished and
any allocated objects freed.

ato_base_deinit() should be called after all other deinitialisation routines are called.
*/
SBR_CSR_EXPORT void sbr_csr_deinit(void);

/**
The default filename for the CSR template file.

@return the default CSR template filename.
*/
SBR_CSR_EXPORT const char *sbr_csr_default_templatefile(void);

/**
Helper method to load an CSR template from a path.

@param ctx the current thread local Context.
@param buffer the address of the buffer to load the contents into - must be freed by the caller.
@param dirname the directory to use. Cannot be NULL. Can include or be the filename.
@param filename the filename to use. Can be NULL if just using dirname.

@return ATO_ERR_OK or an errcode.
*/
SBR_CSR_EXPORT int sbr_csr_loadtemplate(ato_Ctx *ctx, char **buffer, const char *dirname, const char *filename);


SBR_CSR_EXPORT const char *sbr_msgsourcetypestr(sbr_eMsgSourceType msgsrctype);

#ifdef __cplusplus
}
#endif

/*! @} */

#endif /*__SBR_CSR_LIB_H__*/
