/*
This file is for documentation purposes only.
*/

/*! @defgroup sbrcsr_api_csr_types Types
@ingroup sbrcsr_api

@brief
General types used across the SBR CSR API.
*/

/*! @defgroup sbrcsr_api_csr_lib Library
@ingroup sbrcsr_api

@brief
General (miscellaneous) library API.
*/

/*! @defgroup sbrcsr_api_csr CSR Service
@ingroup sbrcsr_api

@brief
The CSR API which encapsulates a CSR Service endpoint and the type of requests to be submitted.

*/

/*! @defgroup sbrcsr_api_csr_reqres Request and Response
@ingroup sbrcsr_api

@brief
This section describes @ref sbrcsr_api_csr_req and @ref sbrcsr_api_csr_res.
*/

/*! @defgroup sbrcsr_api_csr_req Request Message
@ingroup sbrcsr_api_csr_reqres

@brief
A Request message contains one or more @ref sbr_Sbdm objects, as well as a Response (after a submit).

After sbr_req_submit() is called, assuming no errors, a Response object is created and returned to the caller.
The Request object retains a handle to the Response object and will free it when freed itself or when the Request is
resubmitted. The caller should never free the Response object. Only the last Response object is retained for each 
Request object.
*/

/*! @defgroup sbrcsr_api_csr_res Response Message
@ingroup sbrcsr_api_csr_reqres

@brief
A Response message contains one or more @ref sbr_Sbdm objects.
*/

/*! @defgroup sbrcsr_api_csr_sbdmetc Standard Business Document Message
@ingroup sbrcsr_api

@brief
This section describes @ref sbrcsr_api_csr_sbdm and related sections.
*/

/*! @defgroup sbrcsr_api_csr_sbdm SBDM
@ingroup sbrcsr_api_csr_sbdmetc

@brief
The StandardBusinessDocumentMessage (document message or SBDM), represents a collection of business 
documents and header information, in a @ref sbrcsr_api_csr_req or a @ref sbrcsr_api_csr_res.
*/

/*! @defgroup sbrcsr_api_csr_msgparty SBDM Party
@ingroup sbrcsr_api_csr_sbdmetc

@brief
A @ref sbr_Sbdm object can contain one or more @ref sbr_MsgEventItem objects.
*/

/*! @defgroup sbrcsr_api_csr_msgrec SBDM Receipt
@ingroup sbrcsr_api_csr_sbdmetc

@brief
The Receipt details of an @ref sbr_Sbdm Response object.
*/

/*! @defgroup sbrcsr_api_csr_msgts SBDM Timestamp
@ingroup sbrcsr_api_csr_sbdmetc

@brief
A @ref sbr_Sbdm object can contain one or more @ref sbr_MsgTimestamp objects.
*/

/*! @defgroup sbrcsr_api_csr_msgevent SBDM Event
@ingroup sbrcsr_api_csr_sbdmetc

@brief
A @ref sbr_Sbdm object can contain one or more @ref sbr_MsgEventItem objects.
*/

/*! @defgroup sbrcsr_api_csr_doc The Business Document
@ingroup sbrcsr_api_csr_sbdmetc

@brief
The CSR API for a CSR Business Document object.
*/

/*! @defgroup sbrcsr_api_csr_doca The Business Document Attachment
@ingroup sbrcsr_api_csr_sbdmetc

@brief
The CSR API for a CSR Business Document Attachment object.
*/

