/*
This file is for documentation purposes only.
*/

/*! @defgroup sbrcsr_external_apis Dependent APIs

The following modules are required:
- @ref atobase
- @ref atobnet

The following modules are optional. They are used in the example code:
- @ref atoakm which is used as the source of cryptographic material
- @ref atostm which is used as the source of the Security Token (Vanguard STS)

*/

/*! @defgroup sbrcsr SBR CSR

@brief
This SDK is used for submitting SBR business data to the SBR Core Services Channel.

The @ref sbrcsr_overview section discusses some general design background of the API.
The @ref sbrcsr_gettingstarted section discusses usage and is, to some extent, a walkthrough.
The @ref sbrcsr_api section details the individual APIs.
*/


//-----------------------------------------------------------

/*! @defgroup sbrcsr_overview Overview
@ingroup sbrcsr

General design background of the API - see subsections for details.

This is in addition to the notes in ATOBASE @ref atobase_overview.

This documentation assumes familiarity with the SBR Webservices Implementation Guide (SBR WIG).

*/


//-----------------------------------------------------------

/*! @defgroup sbrcsr_gettingstarted Getting Started
@ingroup sbrcsr

Implementing an application using SBRCSR, including considerations to take into account.

*/

//-----------------------------------------------------------

/*! @defgroup sbrcsr_api API
@ingroup sbrcsr

*/
