/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup sbrcsr_gettingstarted_csr

@section sbrcsr_gettingstarted_csr_intro Using the CSR API involves

- using sbr_csr_create() to create one or more CSR service objects,
based on a template used to construct requests, and which represents
    - the CSR end-point (URL) that reports are being submitted to
    - the type of report being submitted (ServiceType)
- using the CSR object and sbr_req_create() to create one or more request objects for managing requests
- using the CSR Request object
    - (optional) to programatically override the template and amend the request content using the @ref sbrcsr_api
    - to submit requests with sbr_req_submit()
- using the CSR Response API to query the response object
    - extract the entire XML response string; or
    - programatically query the response contents using the @ref sbrcsr_api

For example (this just uses the request template as is and extracts the response XML)...

@section sbrcsr_gettingstarted_csr_csr Create the CSR object

@code
ato_Ctx *ctx = NULL;
ato_CfgMgr *ctxmgr = NULL;
sbr_Csr *csr = NULL;
sbr_Request *request = NULL;
sbr_Response *response = NULL;
int errcode = ATO_ERR_OK;

    : // initialise the SDKs.

errcode = sbr_csr_create(ctx, &csr, "lodge", serviceURL, CsrXmlTemplateBuffer);
if (errcode != ATO_ERR_OK) ; // handle the error
    :
@endcode

The parameters are:
- the context
- the address of the CSR object to allocate
- the CSR servicetype - this must match an id of the ServiceType element in the @ref sbrcsr_config
- the endpoint URL - if NULL then load from the configuration
- the buffer containing the XML string for the CSR template - if NULL then load from the file specified in the configuration

@note
The csr object must be freed when finished with - after freeing dependant request objects.

@section sbrcsr_gettingstarted_csr_req Create the CSR Request object

@code
    :
errcode = sbr_req_create(ctx, &request, csr);
if (errcode != ATO_ERR_OK) ; // handle the error
    :
@endcode

@note
The request object must be freed when finished with.

@section sbrcsr_gettingstarted_csr_submit Submit the Request

Prior to submitting a request, there are a variety of methods to set the content of the
request. See the API for more details.

@code
    :
errcode = sbr_req_submit(ctx, request, &response, certificate, privatekey, prooftoken, encryptedAssertion);
if (errcode != ATO_ERR_OK) ; // handle the error
    :
@endcode

The parameters are:
- the CSR Request
- the address of the CSR Response object to allocate
- the X509 certificate used for signing (sourced from the ATOAKM SDK in the section @ref sbrcsr_gettingstarted_akm)
- the private key associated with the X509 certificate
- the prooftoken of a SecurityToken returned by an STS (sourced from the ATOSTM SDK in the section @ref sbrcsr_gettingstarted_stm)
- the encryptedAssertion of a SecurityToken returned by an STS

@note
The response object must not be freed. It will be free when the associated request object is freed.

@section sbrcsr_gettingstarted_csr_res Query the Response

@code
    :
errcode = sbr_res_xml(ctx, csrresponse, &buffer);
if (errcode != ATO_ERR_OK) ; // handle the error
    :
@endcode

The parameters are:
- the CSR Response
- the address of the buffer to allocate to save the XML response to - must be freed by the caller

There are a variety of other methods to query the response object content. See the API for more details.

@section sbrcsr_gettingstarted_csr_cleanup Cleanup

@code
    :
free(buffer);
sbr_csrreq_free(csrrequest);
sbr_csr_free(csr);
@endcode

*/
