/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup sbrcsr_gettingstarted_init

@section sbrcsr_gettingstarted_init_globals Global vars

Call the ato_si_set() method. This is used to set the content of the SoftwareInformation
element in SBR documents submitted to SBR Core Services.

For example:

@code
ato_si_set("Your Organisation Name Here", "SBR CSR Reference Client (C version)", "0.6", buildtime, hash);
@endcode

@section sbrcsr_gettingstarted_init_init Initialise

The following initialises the base SDK and the CSR SDK. The ".._INIT_.." flags control the underlying initialisation.
However only the given values are currently supported.

@code
    int errcode = ATO_ERR_OK;
    ato_Ctx *ctx = NULL;

    // We need at least one context for the main thread prior to initialisation
    ato_ctx_create(&ctx);

    errcode = ato_base_init(ctx, ATO_BASE_INIT_ALL);

    // The following is required only if using the ATOAKM SDK
    if (errcode == ATO_ERR_OK)
        errcode = ato_akm_init(ctx, ATO_AKM_INIT_ALL);

    // The following is required only if using the ATOSTM SDK
    if (errcode == ATO_ERR_OK)
        errcode = ato_stm_init(ctx, ATO_STM_INIT_ALL);

    if (errcode == ATO_ERR_OK)
        errcode = sbr_csr_init(ctx, SBR_CSR_INIT_ALL);
@endcode

@section sbrcsr_gettingstarted_init_cfg Configuration

In order to do anything useful, we need to load a configuration as described in

- ATO Base section @ref atobase_init_config "Initialise a Configuration".

@note
Most of the CSR settings are specific to the type of report that is being lodged. Most of these settings
are therefore accessed using ato_ctx_itemid() where the id is the ServiceType. See the atodefcontexts.xml file
for examples of this or @ref sbrcsr_config.

@section sbrcsr_gettingstarted_init_deinit Deinitialise

At the end of the program lifetime, and after all threads are finished, corresponding config/ctx free and
deinitialisation methods must be called.
@code
    ato_ctx_free(ctx);
    ato_cfgm_free(cfgmgr);

    sbr_csr_deinit();
    ato_stm_deinit(); // if using ATOAKM
    ato_akm_deinit(); // if using ATOSTM
    ato_base_deinit();
@endcode
*/
