#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <time.h>
#include <stdarg.h>

#include "atobase/private/pall.h"

#include "atointernal.h"
#include "inttypes.h"
//#include "interror.h"
#include "interrfn.h"

//static const char *_library = SBR_CSR_LIBRARY;
//static const char *_module = SBR_CSR_MODULE_ERRFN;
//static unsigned long _moduleid = SBR_CSR_MODULEID_ERRFN;

//static int _loglevel = ATO_LOG_WARN;

/*********************************************************************************/
/*
bool sbr__csr_errfn(ato_Ctx *ctx, ato_Err *err, ato_Log *log)
{
    const char *function = "sbr__csr_errfn";
    bool processed = TRUE;
    bool deleted = ato_err_isdeleted(err);
    int errcode = ato_err_code(err);
    sbr_Error *csrerror = ato_err_custom(err);
    if (deleted) {
        if ((errcode >= SBR_CSR_ERR_MIN && errcode <= SBR_CSR_ERR_MAX) && csrerror != NULL)
            sbr__err_free(csrerror);
    } else {
        const char *msg = ato_err_msg(err);
        if (msg == NULL)
            msg = "No error text";
        processed = ATO_LOG_MSGV(log, ATO_LOG_ERR, "%s.%s.%s: %d (%s: %s): %s",
            ato_err_library(err), ato_err_module(err),  ato_err_function(err),
            errcode, ato_err_codename(err), ato_err_codemsg(err), msg);
        if (processed && (errcode >= SBR_CSR_ERR_MIN && errcode <= SBR_CSR_ERR_MAX) && csrerror != NULL) {
            sbr_ErrorCode *code = NULL;
            ATO_LOG_MSGV(log, ATO_LOG_ERR, "%s", "CSR response error details");
            ATO_LOG_MSGV(log, ATO_LOG_ERR, "  reason=%s", sbr_err_reason(csrerror));
            ATO_LOG_MSGV(log, ATO_LOG_ERR, "  node=%s", sbr_err_node(csrerror));
            ATO_LOG_MSGV(log, ATO_LOG_ERR, "  detail=%s", sbr_err_detail(csrerror));
            for (code = sbr_err_code_firstv(csrerror); code; code = sbr_err_code_nextv(csrerror)) {
                ATO_LOG_MSGV(log, ATO_LOG_ERR, "  value=%s", sbr_err_code_value(code));
                ATO_LOG_MSGV(log, ATO_LOG_ERR, "  ns=%s", sbr_err_code_ns(code));
            }
        }
    }
    ATO_IGNORE(ctx);
    return processed;
}


bool sbr__csr_errfn(ato_Ctx *ctx, ato_Err *err, ato_Log *log)
{
    const char *function = "sbr__csr_errfn";
    bool processed = TRUE;
    bool deleted = ato_err_isdeleted(err);
    int errcode = ato_err_code(err);
    sbr_MsgEventItem **csrerrors = ato_err_customobj(err);
    size_t i = 0;
    if (deleted) {
        if ((errcode >= SBR_CSR_ERR_MIN && errcode <= SBR_CSR_ERR_MAX) && csrerrors != NULL) {
            sbr_MsgEventItem *csrerror = NULL;
            while ((csrerror = csrerrors[i++]) != NULL) {
                sbr__msgevent_free(csrerror);
            }
        free(ato_err_customobj(err));
        }
    } else {
        const char *msg = ato_err_msg(err);
        if (msg == NULL)
            msg = "No error text";
        processed = ATO_LOG_MSGV(log, ATO_LOG_ERR, "%s.%s.%s: %d (%s: %s): %s",
            ato_err_library(err), ato_err_module(err),  ato_err_function(err),
            ato_err_code(err), ato_err_codename(err), ato_err_codemsg(err), msg);
        if (processed && (errcode >= SBR_CSR_ERR_MIN && errcode <= SBR_CSR_ERR_MAX) && csrerrors != NULL) {
            sbr_MsgEventItem *csrerror = NULL;
            ATO_LOG_MSGV(log, ATO_LOG_ERR, "%s", "CSR response error details");
            while ((csrerror = csrerrors[i++]) != NULL) {
                ATO_LOG_MSGV(log, ATO_LOG_ERR, "  code=%s", sbr_msgevent_code(csrerror));
                ATO_LOG_MSGV(log, ATO_LOG_ERR, "  type=%s", sbr_msgevent_type(csrerror));
                ATO_LOG_MSGV(log, ATO_LOG_ERR, "  severity=%s", sbr_msgevent_severity(csrerror));
                ATO_LOG_MSGV(log, ATO_LOG_ERR, "  shortdesc=%s", sbr_msgevent_shortdesc(csrerror));
                ATO_LOG_MSGV(log, ATO_LOG_ERR, "  longdesc=%s", sbr_msgevent_longdesc(csrerror));
            }
        }
    }
    ATO_IGNORE(ctx);
    return processed;
}
*/
