#ifndef __SBR_CSR_DOC_INTERNAL_H__
#define __SBR_CSR_DOC_INTERNAL_H__

#include "sbrcsr/doc.h"

typedef struct _sbr_Docs sbr_Docs;

#ifdef __cplusplus
extern "C" {
#endif

extern int sbr__doc_init(void);
extern void sbr__doc_deinit(void);

extern void sbr__doc_create(ato_Ctx *ctx, sbr_Docs **docs, sbr_eMsgSourceType msgsrctype,
                                        ato_Xml *xml, void *pxnode, size_t *attachmentcount);
extern void sbr__doc_free(sbr_Docs *docs);

extern size_t sbr__doc_count(sbr_Docs *docs);
extern void sbr__doc_iterator( sbr_Docs *docs, ato_Iterator **iter);
extern sbr_Doc *sbr__doc_firstv(sbr_Docs *docs);
extern sbr_Doc *sbr__doc_nextv(sbr_Docs *docs);

extern sbr_Doc *sbr__doc_add(ato_Ctx *ctx, sbr_Docs *docs);
extern void sbr__doc_remove(ato_Ctx *ctx, sbr_Docs *docs, sbr_Doc *doc);

extern void sbr__doc_render(ato_Ctx *ctx, sbr_Docs *docs, ato_Xml *xml, void *pxnode);

#ifdef __cplusplus
}
#endif

#endif /*__SBR_CSR_DOC_INTERNAL_H__*/
