#ifndef __SBR_CSR_DOCA_INTERNAL_H__
#define __SBR_CSR_DOCA_INTERNAL_H__

#include "sbrcsr/doca.h"

typedef struct _sbr_DocAs sbr_DocAs;

#ifdef __cplusplus
extern "C" {
#endif

extern int sbr__doca_init(void);
extern void sbr__doca_deinit(void);

extern void sbr__doca_create(ato_Ctx *ctx, sbr_DocAs **attachments, sbr_eMsgSourceType msgsrctype,
                                ato_Xml *xml, void *pxnode, void *pxnodebody, size_t *attachmentcount);
extern void sbr__doca_free(sbr_DocAs *attachments);

extern size_t sbr__doca_count(sbr_DocAs *attachments);
extern void sbr__doca_iterator(sbr_DocAs *attachments, ato_Iterator **iter);
extern sbr_DocA *sbr__doca_firstv(sbr_DocAs *attachments);
extern sbr_DocA *sbr__doca_nextv(sbr_DocAs *attachments);

extern sbr_DocA *sbr__doca_add(ato_Ctx *ctx, sbr_DocAs *attachments);
extern void sbr__doca_remove(ato_Ctx *ctx, sbr_DocAs *attachments, sbr_DocA *attachment);

extern void sbr__doca_render(ato_Ctx *ctx, sbr_DocAs *attachments, ato_Xml *xml, void *pxnode, void *pxnodebody);

#ifdef __cplusplus
}
#endif

#endif /*__SBR_CSR_DOCA_INTERNAL_H__*/
