#ifndef __SBR_CSR_MSGREC_INTERNAL_H__
#define __SBR_CSR_MSGREC_INTERNAL_H__

#include "sbrcsr/msgrec.h"

#ifdef __cplusplus
extern "C" {
#endif

extern int sbr__msgrec_init(void);
extern void sbr__msgrec_deinit(void);

/** @internal
Create the object if xml or pxnode is NULL or if the xml contains the relevant node from which values can be loaded.

If the xml/pxnode is provided and the xml node cannot be found, the object will not be created.
**/
extern void sbr__msgrec_create(ato_Ctx *ctx, sbr_MsgReceipt **receipt,
                             ato_Xml *xml, void *pxnode);
extern void sbr__msgrec_free(sbr_MsgReceipt *receipt);

#ifdef __cplusplus
}
#endif

#endif /*__SBR_CSR_MSGREC_INTERNAL_H__*/
