#ifndef __SBR_CSR_SBDM_INTERNAL_H__
#define __SBR_CSR_SBDM_INTERNAL_H__

#include "sbrcsr/sbdm.h"

#ifdef __cplusplus
extern "C" {
#endif

extern int sbr__sbdm_init(void);
extern void sbr__sbdm_deinit(void);

/** @internal
Create a CSR business document object.

Use sbr__doc_free() to free.

@param obj the address of the CSR document object.
@param sequencenr the sequence number (the object can appear in only one collection).

@return ATO_ERR_OK or an error code.
*/
extern void sbr__sbdm_create(ato_Ctx *ctx, sbr_Sbdm **sbdm, sbr_eMsgSourceType msgsrctype, size_t index, ato_Xml *xml, void *pxnode);

/** @internal
Free the CSR request object if not NULL.
@param doc the document object. If NULL do nothing.
*/
extern void sbr__sbdm_free(sbr_Sbdm *sbdm);

extern void sbr__sbdm_render(ato_Ctx *ctx, sbr_Sbdm *sbdm);

#ifdef __cplusplus
}
#endif

#endif /*__SBR_CSR_SBDM_INTERNAL_H__*/
