#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <time.h>
#include <stdarg.h>

#include "atobase/private/pall.h"

#include "atointernal.h"
#include "inttypes.h"
#include "intmsgrec.h"

static const char *_library = SBR_CSR_LIBRARY;
static const char *_module = SBR_CSR_MODULE_MSGREC;
static unsigned long _moduleid = SBR_CSR_MODULEID_MSGREC;

static ato_eLoglevel _loglevel = ATO_LOG_WARN;

static const char *xReceipt = ".//data:LodgementReceipt";
static const char *xIdentifier = "data:Lodgement.Receipt.Identifier";
static const char *xDatetime = "data:Lodgement.Receipt.Datetime";

/*********************************************************************************/
struct _sbr_MsgReceipt {
    char *id;
    char *datetime;
};

/*********************************************************************************/
static void _setloglevel(ato_eLoglevel level)
{
    _loglevel = level;
}

static void _ato_free(sbr_MsgReceipt *receipt)
{
    if (receipt == NULL) return;

    receipt->id = ato_free(receipt->id);
    receipt->datetime = ato_free(receipt->datetime);
}

static sbr_MsgReceipt *_create(void)
{
    sbr_MsgReceipt *receipt = NULL;
    receipt = calloc(1, sizeof(sbr_MsgReceipt));
    assert(receipt != NULL);
    return receipt;
}

/*********************************************************************************/
int sbr__msgrec_init(void)
{
    static bool invoked = FALSE;
    if (invoked) return ATO_ERR_OK;
    invoked = TRUE;

    ato_initfnloglevel(_library, _module, _moduleid, _loglevel, _setloglevel);
    return ATO_ERR_OK;
}

void sbr__msgrec_deinit(void)
{
}

void sbr__msgrec_create(ato_Ctx *ctx, sbr_MsgReceipt **obj,
                        ato_Xml *xml, void *pxnode)
{
    const char *function = "sbr__msgrec_create";
    int errcode = ATO_ERR_OK;
    sbr_MsgReceipt *receipt = NULL;

    assert(ctx != NULL);
    ATO_ASSERT_ISNOTALLOCATED(obj);

    ATO_CTX_FN_START(ctx);

    if (xml && pxnode) {
        void *xnode = ato_xml_findnode(xml, pxnode, xReceipt, NULL);
        if (xnode) {
            *obj = receipt = _create();
            ato_xml_nodevalue(xml, xnode, xIdentifier, &(receipt->id), FALSE);
            ato_xml_nodevalue(xml, xnode, xDatetime, &(receipt->datetime), FALSE);
        }
    } else {
        *obj = receipt = _create();
    }
    ATO_CTX_FN_END(ctx, errcode);
}

void sbr__msgrec_free(sbr_MsgReceipt *receipt)
{
    if (receipt == NULL) return;
    _ato_free(receipt);
    free(receipt);
}

/*********************************************************************************/
const char *sbr_msgrec_id(sbr_MsgReceipt *receipt)
{
    assert(receipt != NULL);
    return receipt->id;
}

const char *sbr_msgrec_datetime(sbr_MsgReceipt *receipt)
{
    assert(receipt != NULL);
    return receipt->datetime;
}
