<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile doxygen_version="1.9.2">
  <compound kind="group">
    <name>atostm_api_types_modules</name>
    <title>Module defines</title>
    <filename>group__atostm__api__types__modules.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_LIBRARY</name>
      <anchorfile>group__atostm__api__types__modules.html</anchorfile>
      <anchor>gab710f7de39a21b8331b0aab32ac47527</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_MODULE_LIB</name>
      <anchorfile>group__atostm__api__types__modules.html</anchorfile>
      <anchor>ga4f056aa4452d963d59570e4b90b98ac1</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_MODULE_STM</name>
      <anchorfile>group__atostm__api__types__modules.html</anchorfile>
      <anchor>ga2c22a81c8d4641aa3c6309467bd76fc9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_MODULE_TKN</name>
      <anchorfile>group__atostm__api__types__modules.html</anchorfile>
      <anchor>gafe03c1ac6983731cba3fb96a34a030b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_MODULE_ERRFN</name>
      <anchorfile>group__atostm__api__types__modules.html</anchorfile>
      <anchor>ga28c8471ca4ad1ab80ea74519fbd0b604</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_MODULEID_LIB</name>
      <anchorfile>group__atostm__api__types__modules.html</anchorfile>
      <anchor>ga4e39427f944401a55cb3c7614c7813ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_MODULEID_STM</name>
      <anchorfile>group__atostm__api__types__modules.html</anchorfile>
      <anchor>gaa6ae3d50b41b451afed1009830429899</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_MODULEID_TKN</name>
      <anchorfile>group__atostm__api__types__modules.html</anchorfile>
      <anchor>ga671ba5c408b7114731530f944b8f53d7</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_MODULEID_ERRFN</name>
      <anchorfile>group__atostm__api__types__modules.html</anchorfile>
      <anchor>gabd4d351469f8367b52e78d7cac92653c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_INIT_ALL</name>
      <anchorfile>group__atostm__api__types__modules.html</anchorfile>
      <anchor>ga63757dfd723ff457025af57852e05b06</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>atostm_api_types_errcodes</name>
    <title>Error codes</title>
    <filename>group__atostm__api__types__errcodes.html</filename>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_ERR_MIN</name>
      <anchorfile>group__atostm__api__types__errcodes.html</anchorfile>
      <anchor>ga91cdcf562126811f660c1d12401a7110</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_ERR_GENERAL</name>
      <anchorfile>group__atostm__api__types__errcodes.html</anchorfile>
      <anchor>ga504269f4d1d7c01dd244998adc01fbcc</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_ERR_NETSENDER</name>
      <anchorfile>group__atostm__api__types__errcodes.html</anchorfile>
      <anchor>gad19f302a44aa25ca17d6f69ef51b7302</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_ERR_NETRECEIVER</name>
      <anchorfile>group__atostm__api__types__errcodes.html</anchorfile>
      <anchor>ga050546a725e56dbe46591e164d28b7df</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_ERR_NETUNAVAILABLE</name>
      <anchorfile>group__atostm__api__types__errcodes.html</anchorfile>
      <anchor>ga924cdfc06cd3d796bb9a8301a0e0219c</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_ERR_NETCOMMS</name>
      <anchorfile>group__atostm__api__types__errcodes.html</anchorfile>
      <anchor>ga1998ad2fad4646bc3c4134a67bb4eed9</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_ERR_NETTIMEOUT</name>
      <anchorfile>group__atostm__api__types__errcodes.html</anchorfile>
      <anchor>gaa4d154c2c4bb1bbe041f0af2f030580d</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>ATO_STM_ERR_MAX</name>
      <anchorfile>group__atostm__api__types__errcodes.html</anchorfile>
      <anchor>ga9d01a91116190b1fb6ba35c436e5563d</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>atostm_api_types</name>
    <title>Types</title>
    <filename>group__atostm__api__types.html</filename>
    <subgroup>atostm_api_types_modules</subgroup>
    <subgroup>atostm_api_types_errcodes</subgroup>
  </compound>
  <compound kind="group">
    <name>atostm_api_lib</name>
    <title>Library</title>
    <filename>group__atostm__api__lib.html</filename>
    <member kind="function">
      <type>ATO_STM_EXPORT const char *</type>
      <name>ato_stm_version</name>
      <anchorfile>group__atostm__api__lib.html</anchorfile>
      <anchor>ga531394405ac3638d008138408af285fe</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT int</type>
      <name>ato_stm_init</name>
      <anchorfile>group__atostm__api__lib.html</anchorfile>
      <anchor>ga368467b2296e6e5f8f733e8f5a7e947c</anchor>
      <arglist>(ato_Ctx *ctx, unsigned short flag)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT void</type>
      <name>ato_stm_deinit</name>
      <anchorfile>group__atostm__api__lib.html</anchorfile>
      <anchor>ga42a87cff00288b72b85885af756c7e3f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT const char *</type>
      <name>ato_stm_default_templatefile</name>
      <anchorfile>group__atostm__api__lib.html</anchorfile>
      <anchor>ga22c7262f6ef58bba97c538b0a7a5ec21</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT int</type>
      <name>ato_stm_loadtemplate</name>
      <anchorfile>group__atostm__api__lib.html</anchorfile>
      <anchor>ga301e5cca66844d8b5e51e9fd6ed12db8</anchor>
      <arglist>(ato_Ctx *ctx, char **buffer, const char *dirname, const char *filename)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>atostm_api_stm</name>
    <title>STS Service</title>
    <filename>group__atostm__api__stm.html</filename>
    <member kind="typedef">
      <type>struct _ato_Stm</type>
      <name>ato_Stm</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>ga99d8e503bf65d3e9c88ef272c3a35846</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT int</type>
      <name>ato_stm_create</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>gaa71abdbae027c50cf8c007c0e685d3b3</anchor>
      <arglist>(ato_Ctx *ctx, ato_Stm **stm, const char *stsurl, const char *stmtemplate)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT void</type>
      <name>ato_stm_free</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>gacd29611b2a7cc8558fcd8b5932299fff</anchor>
      <arglist>(ato_Ctx *ctx, ato_Stm *stm)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT int</type>
      <name>ato_stm_set_template_vars</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>gafab3eb5f2264935240431d0680a7bf05</anchor>
      <arglist>(ato_Ctx *ctx, ato_Stm *stm, const char *const *vars)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT int</type>
      <name>ato_stm_set_template_varstr</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>gaa0d226097acea9d852d4ca5327afd0a0</anchor>
      <arglist>(ato_Ctx *ctx, ato_Stm *stm, const char *varstr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT void</type>
      <name>ato_stm_purgecache</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>ga1745cdbafc871966c33f67656e4f7924</anchor>
      <arglist>(ato_Ctx *ctx, bool purgeall)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT void</type>
      <name>ato_stm_setexpiryinterval</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>gaad18e725512080fdd9dd11cdb1b30a99</anchor>
      <arglist>(ato_Stm *stm, size_t expirymins)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT size_t</type>
      <name>ato_stm_expiryinterval</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>gab9bc9791e14c9f27c395f44b0b6594fd</anchor>
      <arglist>(ato_Stm *stm)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT int</type>
      <name>ato_stm_stsissue</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>ga8818de2b6c4236b18ded16ed96017340</anchor>
      <arglist>(ato_Ctx *ctx, ato_Stm *stm, ato_StmTkn **st, ato_String *certificate, ato_String *privatekey, const char *relyingpartyurl)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT int</type>
      <name>ato_stm_loadst</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>gaa69c162c4dd51f0fe9d6f404308cf329</anchor>
      <arglist>(ato_Ctx *ctx, ato_Stm *stm, ato_StmTkn **st, ato_String *atorstr)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT size_t</type>
      <name>ato_stm_timeout</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>gad453a7d7774e64f86470d35e4823fa58</anchor>
      <arglist>(ato_Ctx *ctx, ato_Stm *stm)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT void</type>
      <name>ato_stm_settimeout</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>ga7f5ed20491d334419ebe77e4d56cd813</anchor>
      <arglist>(ato_Ctx *ctx, ato_Stm *stm, size_t timeout)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT size_t</type>
      <name>ato_stm_timeoutconnect</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>ga1f665e9ea941aea27a9dc362571dab8f</anchor>
      <arglist>(ato_Ctx *ctx, ato_Stm *stm)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT void</type>
      <name>ato_stm_settimeoutconnect</name>
      <anchorfile>group__atostm__api__stm.html</anchorfile>
      <anchor>gaf33320ed99d2fd35be2aac6913f9660d</anchor>
      <arglist>(ato_Ctx *ctx, ato_Stm *stm, size_t timeout)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>atostm_api_stmtkn</name>
    <title>STM Token</title>
    <filename>group__atostm__api__stmtkn.html</filename>
    <member kind="typedef">
      <type>struct _ato_StmTkn</type>
      <name>ato_StmTkn</name>
      <anchorfile>group__atostm__api__stmtkn.html</anchorfile>
      <anchor>gaf8f7706cc67359d952c0a1fbb12e5db9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT ato_String *</type>
      <name>ato_stmtkn_xml</name>
      <anchorfile>group__atostm__api__stmtkn.html</anchorfile>
      <anchor>ga222bad618ac0886b22782e9d0b38f0bf</anchor>
      <arglist>(ato_StmTkn *st)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT const char *</type>
      <name>ato_stmtkn_key</name>
      <anchorfile>group__atostm__api__stmtkn.html</anchorfile>
      <anchor>ga0e8b9125cb90a4e7b7fc212f5de5c6d1</anchor>
      <arglist>(ato_StmTkn *st)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT ato_String *</type>
      <name>ato_stmtkn_prooftoken</name>
      <anchorfile>group__atostm__api__stmtkn.html</anchorfile>
      <anchor>gaf57a880237812a3619107a136bae71a3</anchor>
      <arglist>(ato_StmTkn *st)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT ato_String *</type>
      <name>ato_stmtkn_assertion</name>
      <anchorfile>group__atostm__api__stmtkn.html</anchorfile>
      <anchor>ga45253b3b5a84deaac9001250ebd8d7e4</anchor>
      <arglist>(ato_StmTkn *st)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT const char *</type>
      <name>ato_stmtkn_samlid</name>
      <anchorfile>group__atostm__api__stmtkn.html</anchorfile>
      <anchor>gae2417a74ebd181a30e370b9610caee28</anchor>
      <arglist>(ato_StmTkn *st)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT bool</type>
      <name>ato_stmtkn_isexpired</name>
      <anchorfile>group__atostm__api__stmtkn.html</anchorfile>
      <anchor>ga0ef0a82891acf3868e1729832375bf44</anchor>
      <arglist>(ato_StmTkn *st)</arglist>
    </member>
    <member kind="function">
      <type>ATO_STM_EXPORT time_t</type>
      <name>ato_stmtkn_expirytime</name>
      <anchorfile>group__atostm__api__stmtkn.html</anchorfile>
      <anchor>gaf60577f2b03a865cbd825805e35952eb</anchor>
      <arglist>(ato_StmTkn *st)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>atostm_external_apis</name>
    <title>Dependent APIs</title>
    <filename>group__atostm__external__apis.html</filename>
  </compound>
  <compound kind="group">
    <name>atostm</name>
    <title>ATO STM</title>
    <filename>group__atostm.html</filename>
    <subgroup>atostm_overview</subgroup>
    <subgroup>atostm_gettingstarted</subgroup>
    <subgroup>atostm_api</subgroup>
  </compound>
  <compound kind="group">
    <name>atostm_overview</name>
    <title>Overview</title>
    <filename>group__atostm__overview.html</filename>
    <subgroup>atostm_intro</subgroup>
    <subgroup>atostm_thirdparty</subgroup>
    <subgroup>atostm_designnotes</subgroup>
    <subgroup>atostm_config</subgroup>
  </compound>
  <compound kind="group">
    <name>atostm_gettingstarted</name>
    <title>Getting Started</title>
    <filename>group__atostm__gettingstarted.html</filename>
    <subgroup>atostm_gettingstarted_summary</subgroup>
    <subgroup>atostm_gettingstarted_init</subgroup>
    <subgroup>atostm_gettingstarted_stm</subgroup>
    <subgroup>atostm_gettingstarted_akm</subgroup>
    <subgroup>atostm_gettingstarted_all</subgroup>
    <subgroup>atostm_gettingstarted_error</subgroup>
  </compound>
  <compound kind="group">
    <name>atostm_api</name>
    <title>API</title>
    <filename>group__atostm__api.html</filename>
    <subgroup>atostm_api_types</subgroup>
    <subgroup>atostm_api_lib</subgroup>
    <subgroup>atostm_api_stm</subgroup>
    <subgroup>atostm_api_stmtkn</subgroup>
  </compound>
  <compound kind="group">
    <name>atostm_gettingstarted_summary</name>
    <title>Summary</title>
    <filename>group__atostm__gettingstarted__summary.html</filename>
  </compound>
  <compound kind="group">
    <name>atostm_gettingstarted_init</name>
    <title>Startup and Shutdown</title>
    <filename>group__atostm__gettingstarted__init.html</filename>
    <docanchor file="group__atostm__gettingstarted__init.html" title="Global vars">atostm_gettingstarted_init_globals</docanchor>
    <docanchor file="group__atostm__gettingstarted__init.html" title="Initialise">atostm_gettingstarted_init_init</docanchor>
    <docanchor file="group__atostm__gettingstarted__init.html" title="Configuration">atostm_gettingstarted_init_cfg</docanchor>
    <docanchor file="group__atostm__gettingstarted__init.html" title="Deinitialise">atostm_gettingstarted_init_deinit</docanchor>
  </compound>
  <compound kind="group">
    <name>atostm_gettingstarted_stm</name>
    <title>Using STM</title>
    <filename>group__atostm__gettingstarted__stm.html</filename>
    <docanchor file="group__atostm__gettingstarted__stm.html" title="Using the STM API involves">atostm_gettingstarted_stm_intro</docanchor>
    <docanchor file="group__atostm__gettingstarted__stm.html" title="Create an STM object">atostm_gettingstarted_stm_create</docanchor>
    <docanchor file="group__atostm__gettingstarted__stm.html" title="Get a SecurityToken">atostm_gettingstarted_stm_st</docanchor>
    <docanchor file="group__atostm__gettingstarted__stm.html" title="Retrieve values from the SecurityToken">atostm_gettingstarted_stm_values</docanchor>
    <docanchor file="group__atostm__gettingstarted__stm.html" title="Cleanup">atostm_gettingstarted_stm_cleanup</docanchor>
  </compound>
  <compound kind="group">
    <name>atostm_gettingstarted_akm</name>
    <title>Getting credentials</title>
    <filename>group__atostm__gettingstarted__akm.html</filename>
    <docanchor file="group__atostm__gettingstarted__akm.html" title="Introduction">atostm_gettingstarted_akm_intro</docanchor>
  </compound>
  <compound kind="group">
    <name>atostm_gettingstarted_all</name>
    <title>All together</title>
    <filename>group__atostm__gettingstarted__all.html</filename>
  </compound>
  <compound kind="group">
    <name>atostm_gettingstarted_error</name>
    <title>Error handling</title>
    <filename>group__atostm__gettingstarted__error.html</filename>
  </compound>
  <compound kind="group">
    <name>atostm_intro</name>
    <title>Introduction</title>
    <filename>group__atostm__intro.html</filename>
  </compound>
  <compound kind="group">
    <name>atostm_thirdparty</name>
    <title>Third party dependencies and licensing</title>
    <filename>group__atostm__thirdparty.html</filename>
  </compound>
  <compound kind="group">
    <name>atostm_designnotes</name>
    <title>Design notes</title>
    <filename>group__atostm__designnotes.html</filename>
    <docanchor file="group__atostm__designnotes.html" title="Content">atostm_designnotes_content</docanchor>
    <docanchor file="group__atostm__designnotes.html" title="Usage">atostm_designnotes_usage</docanchor>
  </compound>
  <compound kind="group">
    <name>atostm_config</name>
    <title>Configuration</title>
    <filename>group__atostm__config.html</filename>
  </compound>
</tagfile>
