#ifndef __ATO_AKM_CR_INTERNAL_H__
#define __ATO_AKM_CR_INTERNAL_H__

#ifndef ATO_AKM_INTERNAL
#error "This file is for internal use only"
#endif

#include "atoakm/private/pcredential.h"

#ifdef __cplusplus
extern "C" {
#endif

extern void ato__cr_create(ato_Ctx *ctx, ato_Credential **obj, ato_ksProperties *ksprop, void *node);
extern void ato__cr_createnew(ato_Ctx *ctx, ato_Credential **obj, ato_ksProperties *ksprop, const char *id, const char *abn, const char *name1, const char *name2, const char *pid);
extern void *ato__cr_clonenode(ato_Ctx *ctx, ato_Xml *dstksxml, ato_Credential *srccr);
/** @internal
Free the credential and optionally delete the underlying node from the backing memory store (XML document)
@param cr the credential object
@param deletenode if TRUE, delete the underlying node
@return NULL
*/
extern void *ato__cr_free(ato_Credential *cr, bool deletenode);
extern void ato__cr_changepwd(ato_Ctx *ctx, ato_Credential *cr, ato_PwdKdf *kdf, ato_PwdKdf *newkdf);

extern bool ato__cr_iscorrectpwd(ato_Ctx *ctx, ato_Credential *cr, ato_PwdKdf *kdf);

extern ato_ksProperties *ato__cr_properties(ato_Credential *cr);

extern void ato__cr_save(ato_Ctx *ctx, ato_Credential *cr);

/**
Return the credential salt as loaded from the store - Base64 DER encoded.
@param cr the credential object.
@return credential salt.
*/
//ATO_AKM_EXPORT const char *ato_cr_b64salt(ato_Credential *cr);
/**
Return the credential P7C as loaded from the store - Base64 DER encoded.
@param cr the credential object.
@return credential P7C.
*/
//ATO_AKM_EXPORT const char *ato_cr_b64p7(ato_Credential *cr);
/**
Return the credential P8 (encrypted private key) as loaded from the store - Base64 DER encoded.
@param cr the credential object.
@return credential P8.
*/
//ATO_AKM_EXPORT const char *ato_cr_b64p8(ato_Credential *cr);
/**
Return the credential integrity value.
@param cr the credential object.
@return credential integrity value.
*/
//ATO_AKM_EXPORT const char *ato_cr_integrityvalue(ato_Credential *cr);

//extern char *ato__cr_str(ato_Credential *cr, char **str);

extern int ato__cr_init(void);
extern void ato__cr_deinit(void);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_AKM_CR_INTERNAL_H__*/
