#ifndef __ATO_AKM_KSPROP_INTERNAL_H__
#define __ATO_AKM_KSPROP_INTERNAL_H__

#ifndef ATO_AKM_INTERNAL
#error "This file is for internal use only"
#endif

#include "atoakm/ksprop.h"

#ifdef __cplusplus
extern "C" {
#endif

extern int ato__ksprop_init(void);
extern void ato__ksprop_deinit(void);

extern int ato__ksprop_createX(ato_Ctx *ctx, ato_ksProperties **obj, const ato_ksProperties *properties, ato_Xml *xml, bool isLegacy, const char *salt, const char *pbemode);

extern bool ato__ksprop_isLegacy(const ato_ksProperties *ksprop);
extern bool ato__ksprop_isPbe2(const ato_ksProperties *ksprop);
extern ato_Pbe *ato__ksprop_pbe(const ato_ksProperties *ksprop);
extern ato_Xml *ato__ksprop_xml(const ato_ksProperties *ksprop);
// On change password, first set pwd to NULL to clear the cached KDF
extern ato_PwdKdf *ato__ksprop_pk(ato_Ctx *ctx, ato_ksProperties *ksprop, const char *pwd);
// This leaves the cached KDF but clears the raw password
extern void ato__ksprop_pk_clr(ato_Ctx *ctx, ato_ksProperties *ksprop);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_AKM_KSPROP_INTERNAL_H__*/
