/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atoakm_gettingstarted_akm

@section atoakm_gettingstarted_akm_intro Using the AKM API involves

- using ato_ks_create() to create one or more keystore management objects,
- using ato_ks_credential() to retrieve credentials
- using the AKM credential API to query the credential

@section atoakm_gettingstarted_akm_create Create an keystore object

@code
ato_Keystore *ks = NULL;
int errcode = ato_ks_create(ctx, &ks, xmlKeystoreBuffer);
@endcode

Parameters are:
- context
- address of the keystore object to allocate
- a buffer containing the keystore XML content

@section atostm_gettingstarted_akm_cr Get a credential for a given user/alias

@code
const ato_Credential *cr = NULL;
cr = ato_ks_credential(ks, alias); // returns NULL if the credential alias does not exist
@endcode

@section atostm_gettingstarted_akm_get Get DER encoded values

for the certificate and private key from the credential

@code
ato_String *certificate = NULL;
ato_String *privatekey = NULL;

// NOTE: You must check the renewable status of the credential, before accessing private key.
if (ato_cr_isrenewable(ctx, cr) && ato_cr_renew(ctx, cr, password) != ATO_ERR_OK)
    printf("Warning: renewal for '%s' failed\n", alias);

// Otherwise getting the private key will generate an assertion
if (ato_cr_certificate(ctx, cr, &certificate) != ATO_ERR_OK ||
        ato_cr_privatekey(ctx, cr, &privatekey, password) != ATO_ERR_OK)

// Renewal is not done in a separate thread. For explicit control call ato_cr_isrenewable but only call ato_cr_renew as required.

@endcode

@section atostm_gettingstarted_akm_cleanup Cleanup

@code
ato_str_free(certificate);
ato_str_free(privatekey);
ato_ks_free(ks);
@endcode
*/
