/*
This file is for documentation purposes only.
*/

//-----------------------------------------------------------

/*! @addtogroup atoakm_designnotes

@section atoakm_designnotes_content Content

The organisation is similar to @ref atobase_designnotes_content "the ATO Base SDK documentation".

@section atoakm_designnotes_usage Usage

Using the SDK follows the pattern:

- Set the global application information (ato_si_set())
- Create an initial global context object (ato_ctx_create())
- Initialise the system (ato_base_init(); ato_amk_init();)
    - Setup any logging (ato_ctx_log_set(), etc) and any known configuration items using @ref atobase_api_public_arg or per context e.g. ato_ctx_cache().
    - Create one or more keystore objects
        - Perform keystore operations
        - Retrieve one or more credentials from the keystore
            - Perform credential operations
    - Free any keystore objects created
- Free the global context object
- Deinitialise the system at application shutdown

Note: initialisation / deinitialises must be perform before / after any threading.

@section atoakm_designnotes_ksstructure Keystore Structure

The keystore structure is not formally published as it is subject to change.
The same keystore format is supported by all SDKs (Java, .Net, C).

@section atoakm_designnotes_kslocation Keystore Location

If using default locations of this file (keystore.xml), they are:

- Windows
    - '%APPDATA%/ATOBE' if %APPDATA% exists; otherwise
    - '%USERPROFILE%/ATOBE'

- MAC
    - '~/Library/Application Support/ATOBE'

- Other
    - '~/.ATOBE'


The API provides for the use of default or alternative keystore locations.

*/
