#ifndef __ATO_ITER_H__
#define __ATO_ITER_H__

/** @addtogroup atobase_api_public_iter

@{
*/

/**
The iteration object.

Note that the underlying container is implementation dependent, private, and therefore not exposed.
The iterator methods simply return the underlying values which must be cast to the correct type.
Warning: this is not type safe, so be sure to use the correct iterator for the type.

Preferably, where an object implements a collection (or multiple), it should provide type-safe wrappers for these methods
for the given collection.
*/
typedef struct _ato_Iterator ato_Iterator;

#ifdef __cplusplus
extern "C" {
#endif

/**
Free an iterator.

@param iter the iterator.

*/
ATO_EXPORT void ato_iter_free(ato_Iterator *iter);

/**
Get the first value in the collection.

This also primes or resets the iterator to the start for use by ato_iter_nextv().

@param iter the iterator.

@return a new iterator.
*/
ATO_EXPORT void *ato_iter_firstv(ato_Iterator *iter);

/**
Get the next value in the collection - see also ato_iter_firstv().

@param iter the iterator.

@return a new iterator.
*/
ATO_EXPORT void *ato_iter_nextv(ato_Iterator *iter);


#ifdef __cplusplus
}
#endif

/*! @} */

#endif /*__ATO_ITER_H__*/

