#ifndef __ATO_LOG_PRIVATE_H__
#define __ATO_LOG_PRIVATE_H__

/* ! @defgroup atobase_api_plog PLog
@ingroup atobase_api_private

@{
*/

#include "atobase/log.h"

#define ATO_LOG_MSG(log, targetlevel, msg) \
    (ato_log_msg((log), (targetlevel), _loglevel, _library, _module, function, (msg)))
#define ATO_LOG_MSGV(log, targetlevel, fmt, ...) \
    (ato_log_msg((log), (targetlevel), _loglevel, _library, _module, function, (fmt), __VA_ARGS__))
#define ATO_LOG_TRACESTART(log) \
    (ato_log_start((log), ATO_LOG_TRACE, _loglevel, _library, _module, function, ""))
#define ATO_LOG_TRACEEND(log, errcode)  \
    (ato_log_end((log), ATO_LOG_TRACE, _loglevel, _library, _module, function, errcode != 0, ""))

//typedef void (ato_setloglevelfn)(ato_eLoglevel level);

#ifdef __cplusplus
extern "C" {
#endif

//ATO_EXPORT const char *ato_log_path_override(ato_Log *log);
//ATO_EXPORT void ato_log_path_override_set(ato_Log *log, const char *path);

#ifdef __cplusplus
}
#endif

/* ! @} */

#endif /*__ATO_LOG_PRIVATE_H__*/

