#ifndef __ATO_UTIL_PRIVATE_H__
#define __ATO_UTIL_PRIVATE_H__

#include <stddef.h>

#include "atobase/private/putilcore.h"
#include "atobase/util.h"

/* ! @defgroup atobase_api_putil PUtil
@ingroup atobase_api_private

General utility methods used in the SDK codebase. They are available to use by application developers
should they so wish.

Note: in API comments elsewhere, the terms "string" generally refers to a 0 terminated char array,
whereas "ato string" refers the @ref ato_String object.

@{
*/

#ifdef __cplusplus
extern "C" {
#endif

/**
Load the file content into a newly created ato_String buffer. The caller must use ato_str_free() when finished.
@param buffer the address of the ato_String buffer to create. This must be initialised to NULL.
@param filepath the file to load the content from into buffer.
@return ATO_ERR_OK(0) if successful, otherwise
- ATO_ERR_FILEOPEN if file cannot be opened (no access or doesn't exist)
- ATO_ERR_FILESTAT if file size cannot be determined.
- ATO_ERR_FILEREAD if file cannot be read.
*/
ATO_EXPORT int ato_fileload(ato_String **buffer, const char* filepath);

/**
Write the buffer content into a file.
@param buffer the ato_String buffer containing the content to write.
@param filepath the file to write the content to. Existing files will be truncated.
@return ATO_ERR_OK(0) if successful, otherwise
- ATO_ERR_FILEOPEN if file cannot be opened or created.
- ATO_ERR_FILEWRITE if file cannot be written.
*/
ATO_EXPORT int ato_filewrite(ato_String *buffer, const char* filepath);

ATO_EXPORT int ato_fileappend(const char *pre, ato_String *buffer, const char *post, const char *filepath);

/**

*/
ATO_EXPORT int ato_base64decode(ato_Ctx *ctx, ato_String **data, ato_String *b64);
// flag=1 will return data value as a null-terminated string
ATO_EXPORT int ato_base64encode2(ato_Ctx *ctx, ato_String **b64, ato_String *data, int flags);
ATO_EXPORT int ato_base64encode(ato_Ctx *ctx, ato_String **b64, ato_String *data);
ATO_EXPORT char *ato_new_salt(ato_Ctx *ctx, char *salt);
ATO_EXPORT int ato_generatehmac(ato_Ctx *ctx, ato_String **hmac, ato_String *input, ato_String *salt);
ATO_EXPORT char *ato_md5(ato_Ctx *ctx, char *data, size_t len, bool hex);

#ifdef __cplusplus
}
#endif

/* ! @} */

#endif /*__ATO_UTIL_PRIVATE_H__*/
