#ifndef __ATO_XML_PRIVATE_H__
#define __ATO_XML_PRIVATE_H__

#include <stddef.h>

/**
This internal API needs serious refactoring. In particular, it should make a lot more use of ato_String.
*/
typedef struct _ato_Xml ato_Xml;

#define ATO_MAX_XPATH_LEN 500

/**
Used in some methods to control how node content is retrieved.
*/
typedef enum {
    ATO_XML_RAW_FALSE, /**< Will apply normal XML processing to the node content */
    ATO_XML_RAW_OUTER, /**< Will dump the node as raw XML text */
    ATO_XML_RAW_INNER /**< Will dump the node as raw XML text but strip the outer XML tags */
} ato_eXmlNodeContent;


typedef void (ato_xml_setnode)(ato_Ctx *ctx, void *obj, const char *id, void *node);

#ifdef __cplusplus
extern "C" {
#endif

ATO_EXPORT void ato_xml_create(ato_Ctx *ctx, ato_Xml **obj, ato_String *buffer);
ATO_EXPORT void *ato_xml_free(ato_Xml *xml);

//deprecated - use ato_xml_namespace_register
ATO_EXPORT void ato_xml_addnamespace(ato_Ctx *ctx, ato_Xml *xml, const char *prefix, const char *uri);
ATO_EXPORT void ato_xml_namespace_register(ato_Ctx *ctx, ato_Xml *xml, const char *prefix, const char *uri);

ATO_EXPORT void ato_xml_savetrim(ato_Ctx *ctx, ato_Xml *xml, ato_String **buffer);
ATO_EXPORT void ato_xml_save(ato_Ctx *ctx, ato_Xml *xml, ato_String **buffer);
ATO_EXPORT void ato_xml_savef(ato_Ctx *ctx, ato_Xml *xml, const char *filepath);
ATO_EXPORT bool ato_xml_isdirty(ato_Xml *xml);
ATO_EXPORT void *ato_xml_findnode(ato_Xml *xml, void *pxnode, const char *xpath, const char *var);
ATO_EXPORT char *ato_xml_value(ato_Xml *xml, void *xnode, char **buffer);
ATO_EXPORT char *ato_xml_valueraw(ato_Xml *xml, void *xnode, char **buffer, bool stripouter);
ATO_EXPORT void ato_xml_setvalue(ato_Xml *xml, void *xnode, const char *value);

ATO_EXPORT void ato_xml_setvaluestr(ato_Xml *xml, void *xnode, ato_String *value);

ATO_EXPORT void *ato_xml_encodedvalue_create(ato_Xml *xml, const char *value);
ATO_EXPORT void *ato_xml_encodedvalue_free(ato_Xml *xml, void *encodedvalue);

ATO_EXPORT bool ato_xml_setnodevaluevar(ato_Xml *xml, void *pxnode, const char *xpath, const char *var, const char *value);
ATO_EXPORT bool ato_xml_setnodevalue(ato_Xml *xml, void *pxnode, const char *xpath, const char *value);
ATO_EXPORT bool ato_xml_setnodevaluelen(ato_Xml *xml, void *pxnode, const char *xpath, const char *value, size_t len);
ATO_EXPORT bool ato_xml_createnodevaluevar(ato_Xml *xml, void *pxnode, const char *xpath, const char *name, const char *var, const char *value);
ATO_EXPORT bool ato_xml_createnodevalue(ato_Xml *xml, void *pxnode, const char *xpath, const char *name, const char *value);
ATO_EXPORT bool ato_xml_createnodevaluelen(ato_Xml *xml, void *pxnode, const char *xpath, const char *name, const char *value, size_t len);
ATO_EXPORT bool ato_xml_createnodevalueraw(ato_Ctx *ctx, ato_Xml *xml, void *pxnode, const char *xpath, const char *name, const char *value);
ATO_EXPORT char *ato_xml_nodevaluevar(ato_Xml *xml, void *pxnode, const char *xpath, const char *var, char **value, ato_eXmlNodeContent raw);
ATO_EXPORT char *ato_xml_nodevalue(ato_Xml *xml, void *pxnode, const char *xpath, char **value, ato_eXmlNodeContent raw);
ATO_EXPORT void ato_xml_setnodes(ato_Ctx *ctx, ato_Xml *xml, const char *nodesxpath, const char *idxpath, ato_xml_setnode setnode, void *userobj);
ATO_EXPORT void ato_xml_deletenode(ato_Xml *xml, void *xnode);
ATO_EXPORT void ato_xml_dropdtd(ato_Xml *xml);
// If xpathExprForParent is NULL parent is pxnode; if pxnode is NULL it is set to docroot; xpathExprForParent is relative to pxnode
ATO_EXPORT void *ato_xml_addnodecopy2(ato_Xml *xml, void *pxnode, const char *xpathExprForParent, void *node, bool clearNs);
ATO_EXPORT void *ato_xml_addnodecopy(ato_Xml *xml, const char *xpathExprForParent, void *node, bool clearNs);
ATO_EXPORT void *ato_xml_clonenode(ato_Xml *xml, void *node, bool clearNs);
ATO_EXPORT void *ato_xml_addnode(ato_Xml *xml, const char *xpathExprForParent, void *node);
ATO_EXPORT void *ato_xml_addnode2(ato_Xml *xml, void *pxnode, const char *xpathExprForParent, void *node);
ATO_EXPORT bool ato_xml_addattr(ato_Xml *xml, void *node, const char *name, const char *value);
ATO_EXPORT void *ato_xml_addelt(ato_Xml *xml, void *pnode, const char *name);
ATO_EXPORT void *ato_xml_createelt(ato_Xml *xml, void *pnode, const char *name);
ATO_EXPORT void *ato_xml_createattr(ato_Xml *xml, void *pnode, const char *name, const char *prefix, const char *href);
ATO_EXPORT char *ato_xml_findnamespace(ato_Xml *xml, void *node, const char *nsprefix, char **value);
ATO_EXPORT void *ato_xml_nodeparent(ato_Xml *xml, void *xnode);
//ATO_EXPORT int ato_xml_createnodevalueraw2(ato_Ctx *ctx, ato_Xml *xml, void *pxnode, const char *value, const char *prefix, const char *href);

ATO_EXPORT void *ato_xml_listload(ato_Xml *xml, void *pxnode, const char *xpath, const char *var);
ATO_EXPORT void *ato_xml_listitem(ato_Xml *xml, void *list, size_t index);
ATO_EXPORT size_t ato_xml_listcount(ato_Xml *xml, void *list);
ATO_EXPORT void ato_xml_listfree(ato_Xml *xml, void *list);

ATO_EXPORT char *ato_xml_root_namespace(ato_Xml *xml, char **value);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_XML_PRIVATE_H__*/
