#ifndef __ATO_SI_H__
#define __ATO_SI_H__

#include <stddef.h>

/** @addtogroup atobase_api_public_si

Provides global details of the application.

@{
*/

#ifdef __cplusplus
extern "C" {
#endif

/**
Set up the application information.

@param organisation Organisation name or individual name.
@param product Name of the application.
@param version Version of the application.
@param timestamp The timestamp of the last build for the application
@param source of the last source code commit - e.g. git repo name
@param hash of the last source code commit - e.g. git sha1

@return ATO_ERR_OK if ok 
*/
ATO_EXPORT int ato_si_set(const char *organisation, const char *product, const char *version, const char *timestamp, const char *source, const char *hash);

/**
Return the organisation name owning the application.
@return organisation name
*/
ATO_EXPORT const char *ato_si_organisation(void);

/**
Return the product name.
@return product name
*/
ATO_EXPORT const char *ato_si_product(void);

/**
Return the version.
@return version
*/
ATO_EXPORT const char *ato_si_version(void);

/**
Return the timestamp of the last build of the application.
@return build timestamp
*/
ATO_EXPORT const char *ato_si_timestamp(void);

/**
Return the source details of the last commit of the application - e.g. git repo.
@return commit source
*/
ATO_EXPORT const char *ato_si_source(void);
/**
Return the commit details of the last commit of the application - e.g. git sha1.
@return commit hash
*/
ATO_EXPORT const char *ato_si_hash(void);

/**
Return everything as | delimited.
@return all info
*/
ATO_EXPORT const char *ato_si_info(void);

#ifdef __cplusplus
}
#endif

/** @} */

#endif /*__ATO_SI_H__*/
