#ifndef __ATO_UTILCORE_H__
#define __ATO_UTILCORE_H__

#include <stddef.h>

/** @defgroup atobase_api_util Util
@ingroup atobase_api_public

@{
*/

#ifdef __cplusplus
extern "C" {
#endif

/**
Alloc sz memory within the library. Use ato_free() to free.
@param sz the size to allocate

@return the buffer.
*/
ATO_EXPORT void *ato_alloc(size_t sz);

/**
Free v if not NULL and return NULL.
Any strings allocated by the dependant libraries should be freed using this.
That is, the library that allocates memory, should free it.
If client code frees such memory, it may work, or may result in segmentation faults.
@param v the buffer to free

@return NULL
*/
ATO_EXPORT void *ato_free(void *v);

#ifdef __cplusplus
}
#endif

/** @} */

#endif /*__ATO_UTILCORE_H__*/
