#ifndef __ATO_BNET_NETD_PRIVATE_H__
#define __ATO_BNET_NETD_PRIVATE_H__

typedef struct _ato_NetData ato_NetData;
typedef struct _ato_NetDataItem ato_NetDataItem;

typedef enum {
        ATO_BNETD_TYPE_UNKNOWN,
        ATO_BNETD_TYPE_MULTI,
        ATO_BNETD_TYPE_SOAP,
        ATO_BNETD_TYPE_XOP,
        ATO_BNETD_TYPE_OTHER,
        ATO_BNETD_TYPE_MULTI_OTHER
} ato_eNetDataType;

typedef enum {
        ATO_BNETD_ENC_NONE,
        ATO_BNETD_ENC_BASE64,
        ATO_BNETD_ENC_QUOTED
} ato_eNetDataTypeEnc;

#ifdef __cplusplus
extern "C" {
#endif

ATO_BNET_EXPORT void ato_bnetd_create(ato_NetData **netdata);
ATO_BNET_EXPORT void *ato_bnetd_free(ato_NetData *netdata);
ATO_BNET_EXPORT ato_NetDataItem *ato_bnetd_additem(ato_NetData *netdata);

ATO_BNET_EXPORT const char *ato_bnetd_cid(ato_NetDataItem *nditem);
ATO_BNET_EXPORT const char *ato_bnetd_cidnoprefix(ato_NetDataItem *nditem);
ATO_BNET_EXPORT ato_eNetDataType ato_bnetd_type(ato_NetDataItem *nditem);
ATO_BNET_EXPORT const char *ato_bnetd_contenttype(ato_NetDataItem *nditem);
ATO_BNET_EXPORT ato_eNetDataTypeEnc ato_bnetd_encoding(ato_NetDataItem *nditem);
ATO_BNET_EXPORT ato_String *ato_bnetd_content(ato_NetDataItem *nditem);

ATO_BNET_EXPORT void ato_bnetd_setcid(ato_NetDataItem *nditem, const char *cid);
ATO_BNET_EXPORT void ato_bnetd_settype(ato_NetDataItem *nditem, ato_eNetDataType type);
ATO_BNET_EXPORT void ato_bnetd_setcontenttype(ato_NetDataItem *nditem, const char *contenttype);
ATO_BNET_EXPORT void ato_bnetd_setencoding(ato_NetDataItem *nditem, ato_eNetDataTypeEnc encoding);
ATO_BNET_EXPORT void ato_bnetd_addcontent(ato_NetDataItem *nditem, ato_String *content);

ATO_BNET_EXPORT size_t ato_bnetd_count(ato_NetData *netdata);
ATO_BNET_EXPORT void ato_bnetd_iterator(ato_NetData *netdata, ato_Iterator **iter);
ATO_BNET_EXPORT ato_NetDataItem *ato_bnetd_firstv(ato_NetData *netdata);
ATO_BNET_EXPORT ato_NetDataItem *ato_bnetd_nextv(ato_NetData *netdata);

ATO_BNET_EXPORT ato_NetDataItem *ato_bnetd_item(ato_NetData *netdata, ato_eNetDataType type);
ATO_BNET_EXPORT ato_NetDataItem *ato_bnetd_item_primary(ato_NetData *netdata);
ATO_BNET_EXPORT void ato_bnetd_clearcontent(ato_NetDataItem *nditem);

ATO_BNET_EXPORT void ato_bnetd_processmpresponse(ato_Ctx *ctx, ato_NetData *netdata, const char *boundaryid);
ATO_BNET_EXPORT bool ato_bnetd_mtom_convertfrom(ato_Ctx *ctx, ato_NetData *netdata, ato_Xml *xml);
ATO_BNET_EXPORT bool ato_bnetd_mtom_convertto(ato_Ctx *ctx, ato_NetData **nddataarg, ato_Xml *xml, const char *mtomxpath, size_t mtomthreshhold, const char *contenttypexpath);

#ifdef __cplusplus
}
#endif

#endif /*__ATO_BNET_NETD_PRIVATE_H__*/
