#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <assert.h>
#include <stdarg.h>

#include "akversion.h"

#include "atobase/all.h"
#include "atobnet/all.h"

#include "../common/util.h"
#include "../common/log.h"

ato_Ctx *g_ctx = NULL;
ato_Log *g_log = NULL;
ato_eLoglevel arg_loglevel = ATO_LOG_ALL;

static const char *arg_organisation = NULL;
static const char *arg_installprefix = NULL;
static bool arg_logfd = FALSE;
static const char *arg_logpath = NULL;
static const char *arg_netlogflag = NULL;
static const char *arg_proxyurl = NULL;
static const char *arg_proxyauthtype = NULL;
static const char *arg_proxybypass = NULL;
static const char *arg_proxyuser = NULL;
static const char *arg_proxypwd = NULL;
static const char *arg_proxypwdfile = NULL;
static const char *arg_sslversion = NULL;
static const char *arg_sslcainfo = NULL;

static void _addargs(void)
{
        ato_arg_add("organisation", TRUE, NULL, NULL, "Name of the organisation or person running this");
        ato_arg_add("installprefix", FALSE, NULL, NULL, "Where to look for dependent library resources, if any");
        ato_arg_add("logfd", FALSE, NULL, NULL, "Some modules will dump data to files for debugging purposes");
        ato_arg_add("logpath", FALSE, "messages.log", NULL, "Set the log path");
        ato_arg_add("loglevel", FALSE, "d", "off|fatal|err|warn|info|debug|trace|all", "Set the loglevel - only need first letter");
        ato_arg_add("netlogflag", FALSE, NULL, NULL, "the network library has additional loglevel settings");
        ato_arg_add("proxyurl", FALSE, NULL, NULL, "proxy server url");
        ato_arg_add("proxyauthtype", FALSE, NULL, NULL, "proxy server authentication type: any (default); basic; digest; ntlm");
        ato_arg_add("proxybypass", FALSE, NULL, NULL, "proxy server bypass list");
        ato_arg_add("proxyuser", FALSE, NULL, NULL, "proxy server user name - if not supplied read the settings from the current config file context");
        ato_arg_add("proxypwd", FALSE, NULL, NULL, "proxy server user password");
        ato_arg_add("proxypwdfile", FALSE, NULL, NULL, "read proxyuser (1st line) and proxypwd (2nd line) from this file");
        ato_arg_add("sslversion", FALSE, NULL, NULL, "CURL options for SSL/TLS(DEFAULT,TLSv1,SSLv2,SSLv3,TLSv1_0,TLSv1_1,TLSv1_2)");
        ato_arg_add("sslcainfo", FALSE, NULL, NULL, "Path to CURL CA store - see CURL option CURLOPT_CAINFO");
}

static void _initargs(void)
{
        arg_organisation = ato_arg_value("organisation");
        arg_installprefix = ato_arg_value("installprefix");;
        arg_logfd = ato_arg_value_bool("logfd");
        arg_logpath = ato_arg_value("logpath");
        arg_loglevel = ato_log_name2level(ato_arg_value("loglevel"));
        arg_netlogflag = ato_arg_value("netlogflag");
        arg_proxyurl = ato_arg_value("proxyurl");
        arg_proxyauthtype = ato_arg_value("proxyauthtype");
        arg_proxybypass = ato_arg_value("proxybypass");
        arg_proxyuser = ato_arg_value("proxyuser");
        arg_proxypwd = ato_arg_value("proxypwd");
        arg_proxypwdfile = ato_arg_value("proxypwdfile");
        arg_sslversion = ato_arg_value("sslversion");
        arg_sslcainfo = ato_arg_value("cainfo");
}

static bool _run_test(void)
{
        printf("\n");
        printf("curl version=%s\n", ato_bnet_curl_version());
        printf("\n");
        return TRUE;
}

static bool _init_tests(void)
{
        int errcode = ATO_ERR_OK;
        if (arg_organisation == NULL || arg_organisation[0] == '\0') { errcode = -1; goto finally; }
        ato_si_set(arg_organisation, _EXE_DESCRIPTION, _EXE_VERSION, _EXE_TIMESTAMP, _EXE_SRC, _EXE_HASH);
        ato_ctx_create(&g_ctx, NULL);

        errcode = ato_base_init(g_ctx, ATO_BASE_INIT_ALL);
        if (errcode == ATO_ERR_OK)
            errcode = ato_bnet_init(g_ctx, ATO_BNET_INIT_ALL);
        if (errcode != ATO_ERR_OK) {
            ato_Err *err = ato_ctx_err(g_ctx);
            printf("Error: %d (%s) %s: %s\n", ato_err_code(err), ato_err_codename(err), ato_err_codemsg(err), ato_err_msg(err));
            goto finally;
        }

        //ato_log_setlogfn(customlogger); //ato_log_setlogfn(verysimplelogger);

        g_log = ato_ctx_log_set(g_ctx, "", "2", NULL, "w");

        // Set log level for all modules
        ato_setloglevel(NULL, 0, arg_loglevel);
        // Some modules dump extra files useful for debugging
        ato_setlogfiledump(ATO_BASE_LIBRARY, 0, arg_logfd);
        // Extra log settings for application network traffic
        ////if (arg_netlogflag) ato_net_setdebugflag(ato_net_names2flag(arg_netlogflag));

finally:
        return errcode == ATO_ERR_OK;
}

static void _deinit_tests(void)
{
        ato_ctx_free(g_ctx);
        ato_bnet_deinit();
        ato_base_deinit();
}

static bool _run_tests(void)
{
        bool ok = FALSE;
        bool inited = FALSE;

        if ((inited = _init_tests()) == FALSE)
                goto finally;

        ato_log_start(g_log, ATO_LOG_INFO, arg_loglevel, "", "", "", ato_si_product());

        ato_log_msg(g_log, ATO_LOG_INFO, arg_loglevel, "", "", "", "BASE Version code=%s", ato_base_version());
        ato_log_msg(g_log, ATO_LOG_INFO, arg_loglevel, "", "", "", "BASE Version code=%s", ato_bnet_version());

        ato_log_msg(g_log, ATO_LOG_INFO, arg_loglevel, "", "", "",
                "SoftwareInfo organisation='%s', product='%s', version='%s', timestamp='%s'",
                ato_si_organisation(), ato_si_product(), ato_si_version(), ato_si_timestamp());

        if (!_run_test())
                goto finally;

        ok = TRUE;
finally:
        if (inited) ato_log_end(g_log, ATO_LOG_INFO, arg_loglevel, "", "", "", FALSE,  ato_si_product());
        _deinit_tests();
        return ok;
}

static void _forceemptyline(void)
{
        printf("\n"); printf("\n"); printf(" \n");
}

static bool _setargs(int argc, const char *argv[])
{
        bool argres = FALSE;
        _addargs();
        if (argc > 1) {
                argres = ato_arg_process(argc, argv);
                if (argres) {
                        _initargs();
                        _forceemptyline();
                        argres = ato_arg_check();
                        _forceemptyline();
                }
                argres = (ato_arg_value_bool("help") == FALSE);
        }
        return argres;
}

int main(int argc, const char *argv[])
{
        bool ok = FALSE;
        setbuf(stdout, NULL);
        if (_setargs(argc, argv)) {
                ato_arg_dump();
                _forceemptyline();
                ok = _run_tests();
                if (!ok) {
                        _forceemptyline();
                        printf("An error occurred - please check logs if any\n");
                }
        } else {
                ato_arg_usage(_EXE_NAME);
        }
        ato_arg_free();
        _forceemptyline();
        return ok == TRUE ? 0: -1;
}
