if (NOT DEFINED AK_DIR_PROJECT)
    message(FATAL_ERROR "ERROR: AK_DIR_PROJECT is not defined")
endif()

get_filename_component(AK_DIR_ROOT "../.." ABSOLUTE BASE_DIR "${CMAKE_CURRENT_LIST_DIR}")
set(AK_DIR_DEP "${AK_DIR_ROOT}/ausid.dep")
set(AK_DEP_DIR "${AK_DIR_DEP}")
set(AK_DEP_DIR_RT "dep/rt")
set(AK_DEP_DIR_BT "dep/bt")

if ("${AK_PLATFORM}" STREQUAL "uwp" OR WINDOWS_STORE)
    set(AK_HOST_OS "win")
    set(AK_HOST_EXT ".bat")
    set(AK_PLATFORM "uwp")
    set(AK_PLATFORM_BEXT ".exe")
    set(AK_PLATFORM_EXT ".bat")
    set(AK_PLATFORM_SHLIB_EXT "dll")
    set(AK_PLATFORM_SHLIB_LINK_EXT "lib")
    set(AK_IS_WINDOZE 1)
    set(AK_PATH_SEP ";")
    set(AK_PATH_LDLIB_NAME "PATH")
elseif (NOT "$ENV{MSYSTEM}" STREQUAL "")
    set(AK_HOST_OS "win")
    set(AK_HOST_EXT ".bat")
    string(TOLOWER "$ENV{MSYSTEM}" AK_PLATFORM)
    set(AK_PLATFORM_BEXT ".exe")
    set(AK_PLATFORM_EXT "")
    set(AK_PLATFORM_SHLIB_EXT "dll")
    set(AK_PLATFORM_SHLIB_LINK_EXT "dll.a")
    set(AK_PATH_SEP ";")
    # Seems msys2 is ignoring LD_LIBRARY_PATH??
    #set(AK_PATH_LDLIB_NAME "LD_LIBRARY_PATH")
    set(AK_PATH_LDLIB_NAME "PATH")
    #if ("$ENV{MSYSTEM}" STREQUAL "MINGW32")
    #    message("Using MINGW32")
    #elseif(${AK_PLATFORM_ALLOW_MSYS})
    #    message("Using MSYS")
    #else()
    #    message(FATAL_ERROR "ERROR: Must use MINGW32 prompt under MSYS2")
    #endif()
elseif (WIN32)
    set(AK_HOST_OS "win")
    set(AK_HOST_EXT ".bat")
    set(AK_PLATFORM "win")
    set(AK_PLATFORM_BEXT ".exe")
    set(AK_PLATFORM_EXT ".bat")
    set(AK_PLATFORM_SHLIB_EXT "dll")
    set(AK_PLATFORM_SHLIB_LINK_EXT "lib")
    set(AK_IS_WINDOZE 1)
    set(AK_PATH_SEP ";")
    set(AK_PATH_LDLIB_NAME "PATH")
elseif (MSYS OR CYGWIN)
    message(FATAL_ERROR "ERROR: MSYS, CYGWIN are not supported - use MSYS2")
elseif (APPLE)
    set(AK_HOST_OS "mac")
    set(AK_HOST_EXT "")
    set(AK_PLATFORM "mac")
    set(AK_PLATFORM_BEXT "")
    set(AK_PLATFORM_EXT "")
    set(AK_PLATFORM_SHLIB_EXT "dylib")
    set(AK_PLATFORM_SHLIB_LINK_EXT "dylib")
    set(AK_PATH_SEP ":")
    set(AK_PATH_LDLIB_NAME "DYLD_LIBRARY_PATH")
elseif (UNIX)
    set(AK_HOST_OS "nix")
    set(AK_HOST_EXT "")
    set(AK_PLATFORM "nix")
    set(AK_PLATFORM_BEXT "")
    set(AK_PLATFORM_EXT "")
    set(AK_PLATFORM_SHLIB_EXT "so")
    set(AK_PLATFORM_SHLIB_LINK_EXT "so")
    set(AK_PATH_SEP ":")
    set(AK_PATH_LDLIB_NAME "LD_LIBRARY_PATH")
else()
    message(FATAL_ERROR "ERROR: Platform not supported")
endif()

set(AK_FALSE 0 f n F N)
set(AK_TRUE 1 t y T Y)

set(AK_DEP_RUNTM_ABRAKMBE "${AK_DIR_DEP}/dep/rt/abrakmbe")

include("${CMAKE_CURRENT_LIST_DIR}/AKModules.cmake")
