if (NOT TARGET doc)
    add_custom_target(doc)
endif()

if (${AK_DOC})
    if (EXISTS ${PROJECT_SOURCE_DIR}/src/dochdrs)
        find_package(Doxygen)
        find_package(HTMLHelp)
        if (NOT DOXYGEN_FOUND)
            message(FATAL_ERROR "Build documentation requested but failed to find doxygen. Either install doxygen or set argument AK_DOC=N")
        endif()
        message(STATUS "DOXY_TAGFILES=${DOXY_TAGFILES}")
        configure_file(${AK_CMAKE_MODULES}/Doxyfile.in ${PROJECT_BINARY_DIR}/Doxyfile @ONLY)
        add_custom_target(doc-${PROJECT_NAME} ${DOXYGEN_EXECUTABLE} ${PROJECT_BINARY_DIR}/Doxyfile COMMENT "Generating API documentation with Doxygen" VERBATIM)
        add_dependencies(doc doc-${PROJECT_NAME})
    endif()
endif()
