#ifndef __SBR_CSR_MSGPARTY_INTERNAL_H__
#define __SBR_CSR_MSGPARTY_INTERNAL_H__

#include "sbrcsr/msgparty.h"

#ifdef __cplusplus
extern "C" {
#endif

extern int sbr__msgp_init(void);
extern void sbr__msgp_deinit(void);

/** @internal
Create the object if xml or pxnode is NULL or if the xml contains the relevant node from which values can be loaded.

If the xml/pxnode is provided and the xml node cannot be found, the object will not be created.
**/
extern void sbr__msgp_create(ato_Ctx *ctx, sbr_MsgParty **party, sbr_eMsgPartyType partytype,
                             ato_Xml *xml, void *pxnode);
extern void sbr__msgp_free(sbr_MsgParty *party);

extern void sbr__msgp_set(ato_Ctx *ctx, sbr_MsgParty *party, const char *iddesignation, const char *idname);
extern void sbr__msgp_render(ato_Ctx *ctx, sbr_MsgParty *party, ato_Xml *xml, void *pxnode);


#ifdef __cplusplus
}
#endif

#endif /*__SBR_CSR_MSGPARTY_INTERNAL_H__*/
