#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <stdarg.h>
#include <sys/stat.h>

#include "atobase/all.h"

#include "util.h"

char *utl_filedir(char *dir, const char *fname)
{
    int maxdepth = 20;
        char _fname[FILENAME_MAX] = {'\0'};
        struct stat sb;
        int count = 0;
        strcpy(dir, ".");
        strcat(strcat(strcpy(_fname, dir), "/"), fname);
        while (stat(_fname, &sb) == -1 && count++ < maxdepth) {
                strcat(dir, "/..");
                strcat(strcat(strcpy(_fname, dir), "/"), fname);
        }
        return count < maxdepth ? dir : NULL;
}

FILE *utl_findandopen(const char *fname, const char *mode)
{
        char _fnameprefix[FILENAME_MAX] = {'\0'};
        char _fname[FILENAME_MAX] = {'\0'};
        FILE *fp = NULL;
        int count = 0;
        strcpy(_fnameprefix, "");
        strcpy(_fname, fname);
        while ((fp = fopen(_fname, mode)) == NULL && count++ < 20) {
                strcat(_fnameprefix, "../");
                strcpy(_fname, _fnameprefix);
                strcat(_fname, fname);
        }
        return fp;
}

// This is not portable for binary files but should be fine for POSIX and Windows.
static long _filesize(FILE *fp)
{
        long start, end;

        if (fseek(fp, 0, SEEK_SET) != 0)
                return 0;
        if ((start = ftell(fp)) == -1L)
                return 0;
        if (fseek(fp, 0, SEEK_END) != 0)
                return 0;
        if ((end = ftell(fp)) == -1L)
                return 0;
        if (fseek(fp, 0, SEEK_SET) != 0)
                return 0;
        return end - start;
}

long utl_filesize(const char *filepath)
{
        FILE *fp = NULL;
        long len = 0;

        if ((fp = fopen(filepath, "rb")) == NULL)
                return 0;
        len = _filesize(fp);
        fclose(fp);
        return len;
}

size_t utl_loadfile(char **buf, const char *filepath, bool recurseup)
{
        FILE *fp = NULL;
        size_t len = 0, rlen = 0;

        assert(buf != NULL);
        assert(filepath != NULL);

        if (recurseup)
                fp = utl_findandopen(filepath, "rb");
        else
                fp = fopen(filepath, "rb");
        if (fp == NULL) {
                printf("Failed to open file %s\n", filepath);
                goto finally;
        }

        if ((len = (size_t)_filesize(fp)) == 0) {
                printf("Failed to stat file %s\n", filepath);
                goto finally;
        }

        *buf = calloc(len + 1, 1);
        assert(*buf != NULL);

        rlen = fread(*buf, 1, len, fp);
        if (rlen != len) {
                printf("Failed to read file %s (len=%" PRINTF_SIZET "u,rlen=%" PRINTF_SIZET "u)\n", filepath, len, rlen);
                len = 0;
                goto finally;
        }

finally:
        if (len == 0 && *buf) free(*buf);
        if (fp != NULL) fclose(fp);
        return len;
}
